/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.schema;

import io.permazen.core.InvalidSchemaException;
import io.permazen.schema.SchemaField;
import io.permazen.schema.SchemaFieldSwitch;
import io.permazen.schema.XMLConstants;
import io.permazen.util.DiffGenerating;
import io.permazen.util.Diffs;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SimpleSchemaField
extends SchemaField
implements DiffGenerating<SimpleSchemaField> {
    private String type;
    private long encodingSignature;
    private boolean indexed;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.verifyNotLockedDown();
        this.type = type;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.verifyNotLockedDown();
        this.indexed = indexed;
    }

    public long getEncodingSignature() {
        return this.encodingSignature;
    }

    public void setEncodingSignature(long encodingSignature) {
        this.verifyNotLockedDown();
        this.encodingSignature = encodingSignature;
    }

    @Override
    void validate() {
        super.validate();
        this.validateType();
    }

    void validateType() {
        if (this.type == null) {
            throw new InvalidSchemaException("invalid " + this + ": no type specified");
        }
        if (!Pattern.compile("\\p{javaJavaIdentifierStart}[-.\\p{javaJavaIdentifierPart}]*(\\[\\]){0,255}").matcher(this.type).matches()) {
            throw new InvalidSchemaException("invalid " + super.toString() + " type `" + this.type + "': does not match pattern \"" + "\\p{javaJavaIdentifierStart}[-.\\p{javaJavaIdentifierPart}]*(\\[\\]){0,255}" + "\"");
        }
    }

    @Override
    public <R> R visit(SchemaFieldSwitch<R> target) {
        return target.caseSimpleSchemaField(this);
    }

    @Override
    final boolean isCompatibleWith(SchemaField field) {
        if (field.getClass() != this.getClass()) {
            return false;
        }
        SimpleSchemaField that = (SimpleSchemaField)field;
        return this.isCompatibleType(that) && this.encodingSignature == that.encodingSignature && this.indexed == that.indexed;
    }

    boolean isCompatibleType(SimpleSchemaField that) {
        return Objects.equals(this.type, that.type);
    }

    @Override
    final void writeCompatibilityHashData(DataOutputStream output) throws IOException {
        super.writeCompatibilityHashData(output);
        this.writeFieldTypeCompatibilityHashData(output);
        output.writeLong(this.encodingSignature);
        output.writeBoolean(this.indexed);
    }

    void writeFieldTypeCompatibilityHashData(DataOutputStream output) throws IOException {
        output.writeUTF(this.type);
    }

    public Diffs differencesFrom(SimpleSchemaField that) {
        Diffs diffs = new Diffs(super.differencesFrom(that));
        this.addTypeDifference(diffs, that);
        if (this.encodingSignature != that.encodingSignature) {
            diffs.add("changed field type encoding signature from " + that.encodingSignature + " to " + this.encodingSignature);
        }
        if (this.indexed != that.indexed) {
            diffs.add((this.indexed ? "added" : "removed") + " index on field");
        }
        return diffs;
    }

    void addTypeDifference(Diffs diffs, SimpleSchemaField that) {
        if (!Objects.equals(this.type, that.type)) {
            diffs.add("changed field type from `" + that.type + "' to `" + this.type + "'");
        }
    }

    @Override
    void readAttributes(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        Long encodingSignatureAttr;
        Boolean indexedAttr;
        super.readAttributes(reader, formatVersion);
        String typeAttr = this.getAttr(reader, XMLConstants.TYPE_ATTRIBUTE, false);
        if (typeAttr != null) {
            this.setType(typeAttr);
        }
        if ((indexedAttr = this.getBooleanAttr(reader, XMLConstants.INDEXED_ATTRIBUTE, false)) != null) {
            this.setIndexed(indexedAttr);
        }
        if ((encodingSignatureAttr = this.getLongAttr(reader, XMLConstants.ENCODING_SIGNATURE_ATTRIBUTE, false)) != null) {
            this.setEncodingSignature(encodingSignatureAttr);
        }
    }

    @Override
    final void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        this.writeXML(writer, true);
    }

    void writeXML(XMLStreamWriter writer, boolean includeName) throws XMLStreamException {
        writer.writeEmptyElement(XMLConstants.SIMPLE_FIELD_TAG.getNamespaceURI(), XMLConstants.SIMPLE_FIELD_TAG.getLocalPart());
        this.writeAttributes(writer, includeName);
    }

    @Override
    final void writeAttributes(XMLStreamWriter writer, boolean includeName) throws XMLStreamException {
        super.writeAttributes(writer, includeName);
        this.writeSimpleAttributes(writer);
        if (this.encodingSignature != 0L) {
            writer.writeAttribute(XMLConstants.ENCODING_SIGNATURE_ATTRIBUTE.getNamespaceURI(), XMLConstants.ENCODING_SIGNATURE_ATTRIBUTE.getLocalPart(), "" + this.encodingSignature);
        }
    }

    void writeSimpleAttributes(XMLStreamWriter writer) throws XMLStreamException {
        this.writeTypeAttribute(writer);
        if (this.indexed) {
            writer.writeAttribute(XMLConstants.INDEXED_ATTRIBUTE.getNamespaceURI(), XMLConstants.INDEXED_ATTRIBUTE.getLocalPart(), "" + this.indexed);
        }
    }

    void writeTypeAttribute(XMLStreamWriter writer) throws XMLStreamException {
        if (this.type != null) {
            writer.writeAttribute(XMLConstants.TYPE_ATTRIBUTE.getNamespaceURI(), XMLConstants.TYPE_ATTRIBUTE.getLocalPart(), this.type);
        }
    }

    @Override
    public String toString() {
        return super.toString() + (this.type != null ? " of type " + this.type : "") + (this.encodingSignature != 0L ? " (encoding " + this.encodingSignature + ")" : "");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SimpleSchemaField that = (SimpleSchemaField)obj;
        return Objects.equals(this.type, that.type) && this.encodingSignature == that.encodingSignature && this.indexed == that.indexed;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.type) ^ Long.valueOf(this.encodingSignature).hashCode() ^ (this.indexed ? 1 : 0);
    }

    @Override
    public SimpleSchemaField clone() {
        return (SimpleSchemaField)super.clone();
    }
}

