
package io.permit.sdk.openapi.models;

import java.util.Date;
import java.util.HashMap;
import javax.annotation.Generated;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;


/**
 * ConditionSetRead
 * <p>
 * 
 * 
 */
@Generated("jsonschema2pojo")
public class ConditionSetRead {

    /**
     * Key
     * <p>
     * A unique id by which Permit will identify the condition set. The key will be used as the generated rego rule name.
     * (Required)
     * 
     */
    @SerializedName("key")
    @Expose
    public java.lang.String key;
    /**
     * the type of the set: UserSet or ResourceSet
     * 
     */
    @SerializedName("type")
    @Expose
    public ConditionSetType type;
    /**
     * Autogenerated
     * <p>
     * whether the set was autogenerated by the system.
     * 
     */
    @SerializedName("autogenerated")
    @Expose
    public Boolean autogenerated = false;
    /**
     * Resource Id
     * <p>
     * For ResourceSets, the id of the base resource.
     * 
     */
    @SerializedName("resource_id")
    @Expose
    public java.lang.String resourceId;
    /**
     * Id
     * <p>
     * Unique id of the condition set
     * (Required)
     * 
     */
    @SerializedName("id")
    @Expose
    public java.lang.String id;
    /**
     * Organization Id
     * <p>
     * Unique id of the organization that the condition set belongs to.
     * (Required)
     * 
     */
    @SerializedName("organization_id")
    @Expose
    public java.lang.String organizationId;
    /**
     * Project Id
     * <p>
     * Unique id of the project that the condition set belongs to.
     * (Required)
     * 
     */
    @SerializedName("project_id")
    @Expose
    public java.lang.String projectId;
    /**
     * Environment Id
     * <p>
     * Unique id of the environment that the condition set belongs to.
     * (Required)
     * 
     */
    @SerializedName("environment_id")
    @Expose
    public java.lang.String environmentId;
    /**
     * Created At
     * <p>
     * Date and time when the condition set was created (ISO_8601 format).
     * (Required)
     * 
     */
    @SerializedName("created_at")
    @Expose
    public Date createdAt;
    /**
     * Updated At
     * <p>
     * Date and time when the condition set was last updated/modified (ISO_8601 format).
     * (Required)
     * 
     */
    @SerializedName("updated_at")
    @Expose
    public Date updatedAt;
    /**
     * ResourceRead
     * <p>
     * 
     * 
     */
    @SerializedName("resource")
    @Expose
    public ResourceRead resource;
    /**
     * Name
     * <p>
     * A descriptive name for the set, i.e: 'US based employees' or 'Users behind VPN'
     * (Required)
     * 
     */
    @SerializedName("name")
    @Expose
    public java.lang.String name;
    /**
     * Description
     * <p>
     * an optional longer description of the set
     * 
     */
    @SerializedName("description")
    @Expose
    public java.lang.String description;
    /**
     * Conditions
     * <p>
     * a boolean expression that consists of multiple conditions, with and/or logic.
     * 
     */
    @SerializedName("conditions")
    @Expose
    public HashMap<String, Object> conditions;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConditionSetRead() {
    }

    /**
     * 
     * @param organizationId
     * @param createdAt
     * @param environmentId
     * @param name
     * @param id
     * @param projectId
     * @param key
     * @param updatedAt
     */
    public ConditionSetRead(java.lang.String key, java.lang.String id, java.lang.String organizationId, java.lang.String projectId, java.lang.String environmentId, Date createdAt, Date updatedAt, java.lang.String name) {
        super();
        this.key = key;
        this.id = id;
        this.organizationId = organizationId;
        this.projectId = projectId;
        this.environmentId = environmentId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.name = name;
    }

    public ConditionSetRead withKey(java.lang.String key) {
        this.key = key;
        return this;
    }

    public ConditionSetRead withType(ConditionSetType type) {
        this.type = type;
        return this;
    }

    public ConditionSetRead withAutogenerated(Boolean autogenerated) {
        this.autogenerated = autogenerated;
        return this;
    }

    public ConditionSetRead withResourceId(java.lang.String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public ConditionSetRead withId(java.lang.String id) {
        this.id = id;
        return this;
    }

    public ConditionSetRead withOrganizationId(java.lang.String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public ConditionSetRead withProjectId(java.lang.String projectId) {
        this.projectId = projectId;
        return this;
    }

    public ConditionSetRead withEnvironmentId(java.lang.String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public ConditionSetRead withCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public ConditionSetRead withUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public ConditionSetRead withResource(ResourceRead resource) {
        this.resource = resource;
        return this;
    }

    public ConditionSetRead withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    public ConditionSetRead withDescription(java.lang.String description) {
        this.description = description;
        return this;
    }

    public ConditionSetRead withConditions(HashMap<String, Object> conditions) {
        this.conditions = conditions;
        return this;
    }

}
