/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.spark.pinecone;

import com.google.protobuf.Struct;
import io.pinecone.clients.Pinecone;
import io.pinecone.configs.PineconeConfig;
import io.pinecone.configs.PineconeConnection;
import io.pinecone.proto.SparseValues;
import io.pinecone.proto.UpsertRequest;
import io.pinecone.proto.UpsertResponse;
import io.pinecone.proto.Vector;
import io.pinecone.spark.pinecone.PineconeDataWriter$;
import io.pinecone.spark.pinecone.PineconeOptions;
import io.pinecone.spark.pinecone.package;
import io.pinecone.spark.pinecone.package$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001de\u0001\u0002\u001d:\u0001\u0006C\u0001\"\u001d\u0001\u0003\u0016\u0004%\tA\u001d\u0005\tm\u0002\u0011\t\u0012)A\u0005g\"Aq\u000f\u0001BK\u0002\u0013\u0005\u0001\u0010\u0003\u0005}\u0001\tE\t\u0015!\u0003z\u0011!i\bA!f\u0001\n\u0003q\b\"CA\u0004\u0001\tE\t\u0015!\u0003\u0000\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017A\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u00033A\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005]\u0002\u0001)A\u0005\u0003WA\u0001B\u000f\u0001C\u0002\u0013%\u0011\u0011\b\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002<!I\u0011\u0011\n\u0001C\u0002\u0013%\u00111\n\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002N!I\u0011Q\u000b\u0001A\u0002\u0013%\u0011q\u000b\u0005\n\u0003\u001b\u0003\u0001\u0019!C\u0005\u0003\u001fC\u0001\"a'\u0001A\u0003&\u0011\u0011\f\u0005\t\u0003;\u0003\u0001\u0019!C\u0005e\"I\u0011q\u0014\u0001A\u0002\u0013%\u0011\u0011\u0015\u0005\b\u0003K\u0003\u0001\u0015)\u0003t\u0011!\t9\u000b\u0001a\u0001\n\u0013\u0011\b\"CAU\u0001\u0001\u0007I\u0011BAV\u0011\u001d\ty\u000b\u0001Q!\nMD\u0001\"!-\u0001\u0005\u0004%IA\u001d\u0005\b\u0003g\u0003\u0001\u0015!\u0003t\u0011!\t)\f\u0001a\u0001\n\u0003\u0011\b\"CA\\\u0001\u0001\u0007I\u0011AA]\u0011\u001d\ti\f\u0001Q!\nMDa!\u0014\u0001\u0005B\u0005}\u0006bBAc\u0001\u0011\u0005\u0013q\u0019\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\t\u0019\u000e\u0001C!\u0003#Dq!!6\u0001\t\u0013\t\t\u000eC\u0004\u0002X\u0002!I!!5\t\u0013\u0005e\u0007!!A\u0005\u0002\u0005m\u0007\"CAr\u0001E\u0005I\u0011AAs\u0011%\tY\u0010AI\u0001\n\u0003\ti\u0010C\u0005\u0003\u0002\u0001\t\n\u0011\"\u0001\u0003\u0004!I!q\u0001\u0001\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\t\u0005\u001f\u0001\u0011\u0011!C\u0001e\"I!\u0011\u0003\u0001\u0002\u0002\u0013\u0005!1\u0003\u0005\n\u0005;\u0001\u0011\u0011!C!\u0005?A\u0011B!\u000b\u0001\u0003\u0003%\tAa\u000b\t\u0013\tU\u0002!!A\u0005B\t]\u0002\"\u0003B\u001e\u0001\u0005\u0005I\u0011\tB\u001f\u0011%\u0011y\u0004AA\u0001\n\u0003\u0012\t\u0005C\u0005\u0003D\u0001\t\t\u0011\"\u0011\u0003F\u001dI!\u0011J\u001d\u0002\u0002#\u0005!1\n\u0004\tqe\n\t\u0011#\u0001\u0003N!9\u0011\u0011\u0002\u001a\u0005\u0002\t\r\u0004\"\u0003B e\u0005\u0005IQ\tB!\u0011%\u0011)GMA\u0001\n\u0003\u00139\u0007C\u0005\u0003pI\n\t\u0011\"!\u0003r!I!1\u0011\u001a\u0002\u0002\u0013%!Q\u0011\u0002\u0013!&tWmY8oK\u0012\u000bG/Y,sSR,'O\u0003\u0002;w\u0005A\u0001/\u001b8fG>tWM\u0003\u0002={\u0005)1\u000f]1sW*\u0011!H\u0010\u0006\u0002\u007f\u0005\u0011\u0011n\\\u0002\u0001'\u0015\u0001!IS0n!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003mC:<'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013aa\u00142kK\u000e$\bcA&X36\tAJ\u0003\u0002N\u001d\u0006)qO]5uK*\u0011q\nU\u0001\nG>tg.Z2u_JT!!\u0015*\u0002\u0007M\fHN\u0003\u0002='*\u0011A+V\u0001\u0007CB\f7\r[3\u000b\u0003Y\u000b1a\u001c:h\u0013\tAFJ\u0001\u0006ECR\fwK]5uKJ\u0004\"AW/\u000e\u0003mS!\u0001\u0018)\u0002\u0011\r\fG/\u00197zgRL!AX.\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\t\u0003A*t!!Y4\u000f\u0005\t,W\"A2\u000b\u0005\u0011\u0004\u0015A\u0002\u001fs_>$h(C\u0001g\u0003\u0015\u00198-\u00197b\u0013\tA\u0017.A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0019L!a\u001b7\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005!L\u0007C\u00018p\u001b\u0005I\u0017B\u00019j\u0005\u001d\u0001&o\u001c3vGR\f1\u0002]1si&$\u0018n\u001c8JIV\t1\u000f\u0005\u0002oi&\u0011Q/\u001b\u0002\u0004\u0013:$\u0018\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0013A\u0002;bg.LE-F\u0001z!\tq'0\u0003\u0002|S\n!Aj\u001c8h\u0003\u001d!\u0018m]6JI\u0002\nqa\u001c9uS>t7/F\u0001\u0000!\u0011\t\t!a\u0001\u000e\u0003eJ1!!\u0002:\u0005=\u0001\u0016N\\3d_:,w\n\u001d;j_:\u001c\u0018\u0001C8qi&|gn\u001d\u0011\u0002\rqJg.\u001b;?)!\ti!a\u0004\u0002\u0012\u0005M\u0001cAA\u0001\u0001!)\u0011o\u0002a\u0001g\")qo\u0002a\u0001s\")Qp\u0002a\u0001\u007f\u0006\u0019An\\4\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}Q+A\u0003tY\u001a$$.\u0003\u0003\u0002$\u0005u!A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002,A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022u\nqaY8oM&<7/\u0003\u0003\u00026\u0005=\"A\u0004)j]\u0016\u001cwN\\3D_:4\u0017nZ\u0001\bG>tg-[4!+\t\tY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t%P\u0001\bG2LWM\u001c;t\u0013\u0011\t)%a\u0010\u0003\u0011AKg.Z2p]\u0016\f\u0011\u0002]5oK\u000e|g.\u001a\u0011\u0002\t\r|gN\\\u000b\u0003\u0003\u001b\u0002B!!\f\u0002P%!\u0011\u0011KA\u0018\u0005I\u0001\u0016N\\3d_:,7i\u001c8oK\u000e$\u0018n\u001c8\u0002\u000b\r|gN\u001c\u0011\u0002!U\u00048/\u001a:u\u0005VLG\u000eZ3s\u001b\u0006\u0004XCAA-!!\tY&!\u001a\u0002j\u0005eTBAA/\u0015\u0011\ty&!\u0019\u0002\u000f5,H/\u00192mK*\u0019\u00111M5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0005u#aA'baB!\u00111NA:\u001d\u0011\ti'a\u001c\u0011\u0005\tL\u0017bAA9S\u00061\u0001K]3eK\u001aLA!!\u001e\u0002x\t11\u000b\u001e:j]\u001eT1!!\u001dj!\u0011\tY(a\"\u000f\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!>\u0003\u0015\u0001(o\u001c;p\u0013\u0011\t))a \u0002\u001bU\u00038/\u001a:u%\u0016\fX/Z:u\u0013\u0011\tI)a#\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011QQA@\u0003Q)\bo]3si\n+\u0018\u000e\u001c3fe6\u000b\u0007o\u0018\u0013fcR!\u0011\u0011SAL!\rq\u00171S\u0005\u0004\u0003+K'\u0001B+oSRD\u0011\"!'\u0012\u0003\u0003\u0005\r!!\u0017\u0002\u0007a$\u0013'A\tvaN,'\u000f\u001e\"vS2$WM]'ba\u0002\nQcY;se\u0016tGOV3di>\u00148/\u00138CCR\u001c\u0007.A\rdkJ\u0014XM\u001c;WK\u000e$xN]:J]\n\u000bGo\u00195`I\u0015\fH\u0003BAI\u0003GC\u0001\"!'\u0015\u0003\u0003\u0005\ra]\u0001\u0017GV\u0014(/\u001a8u-\u0016\u001cGo\u001c:t\u0013:\u0014\u0015\r^2iA\u0005yAo\u001c;bYZ+7\r^8s'&TX-A\nu_R\fGNV3di>\u00148+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u00065\u0006\u0002CAM/\u0005\u0005\t\u0019A:\u0002!Q|G/\u00197WK\u000e$xN]*ju\u0016\u0004\u0013\u0001D7bq\n\u000bGo\u00195TSj,\u0017!D7bq\n\u000bGo\u00195TSj,\u0007%A\nu_R\fGNV3di>\u00148o\u0016:jiR,g.A\fu_R\fGNV3di>\u00148o\u0016:jiR,gn\u0018\u0013fcR!\u0011\u0011SA^\u0011!\tI\nHA\u0001\u0002\u0004\u0019\u0018\u0001\u0006;pi\u0006dg+Z2u_J\u001cxK]5ui\u0016t\u0007\u0005\u0006\u0003\u0002\u0012\u0006\u0005\u0007BBAb=\u0001\u0007\u0011,\u0001\u0004sK\u000e|'\u000fZ\u0001\u0007G>lW.\u001b;\u0015\u0005\u0005%\u0007cA&\u0002L&\u0019\u0011Q\u001a'\u0003']\u0013\u0018\u000e^3s\u0007>lW.\u001b;NKN\u001c\u0018mZ3\u0002\u000b\u0005\u0014wN\u001d;\u0015\u0005\u0005E\u0015!B2m_N,\u0017aB2mK\u0006tW\u000f]\u0001\u0012M2,8\u000f\u001b\"bi\u000eDGk\\%oI\u0016D\u0018\u0001B2paf$\u0002\"!\u0004\u0002^\u0006}\u0017\u0011\u001d\u0005\bc\u0012\u0002\n\u00111\u0001t\u0011\u001d9H\u0005%AA\u0002eDq! \u0013\u0011\u0002\u0003\u0007q0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d(fA:\u0002j.\u0012\u00111\u001e\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003%)hn\u00195fG.,GMC\u0002\u0002v&\f!\"\u00198o_R\fG/[8o\u0013\u0011\tI0a<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}(fA=\u0002j\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0003U\ry\u0018\u0011^\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t-\u0001cA\"\u0003\u000e%\u0019\u0011Q\u000f#\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0003B\u000e!\rq'qC\u0005\u0004\u00053I'aA!os\"A\u0011\u0011\u0014\u0016\u0002\u0002\u0003\u00071/A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\u0003\u0005\u0004\u0003$\t\u0015\"QC\u0007\u0003\u0003CJAAa\n\u0002b\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011iCa\r\u0011\u00079\u0014y#C\u0002\u00032%\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001a2\n\t\u00111\u0001\u0003\u0016\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011YA!\u000f\t\u0011\u0005eU&!AA\u0002M\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002g\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\f\u00051Q-];bYN$BA!\f\u0003H!I\u0011\u0011\u0014\u0019\u0002\u0002\u0003\u0007!QC\u0001\u0013!&tWmY8oK\u0012\u000bG/Y,sSR,'\u000fE\u0002\u0002\u0002I\u001aRA\rB(\u00057\u0002\u0012B!\u0015\u0003XMLx0!\u0004\u000e\u0005\tM#b\u0001B+S\u00069!/\u001e8uS6,\u0017\u0002\u0002B-\u0005'\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u0011iF!\u0019\u000e\u0005\t}#BA G\u0013\rY'q\f\u000b\u0003\u0005\u0017\nQ!\u00199qYf$\u0002\"!\u0004\u0003j\t-$Q\u000e\u0005\u0006cV\u0002\ra\u001d\u0005\u0006oV\u0002\r!\u001f\u0005\u0006{V\u0002\ra`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ha \u0011\u000b9\u0014)H!\u001f\n\u0007\t]\u0014N\u0001\u0004PaRLwN\u001c\t\u0007]\nm4/_@\n\u0007\tu\u0014N\u0001\u0004UkBdWm\r\u0005\n\u0005\u00033\u0014\u0011!a\u0001\u0003\u001b\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005\u0011\u0005")
public class PineconeDataWriter
implements DataWriter<InternalRow>,
Serializable,
Product {
    private final int partitionId;
    private final long taskId;
    private final PineconeOptions options;
    private final Logger log;
    private final PineconeConfig config;
    private final Pinecone pinecone;
    private final PineconeConnection conn;
    private Map<String, UpsertRequest.Builder> upsertBuilderMap;
    private int currentVectorsInBatch;
    private int totalVectorSize;
    private final int maxBatchSize;
    private int totalVectorsWritten;

    public static Option<Tuple3<Object, Object, PineconeOptions>> unapply(PineconeDataWriter x$0) {
        return PineconeDataWriter$.MODULE$.unapply(x$0);
    }

    public static PineconeDataWriter apply(int partitionId, long taskId, PineconeOptions options) {
        return PineconeDataWriter$.MODULE$.apply(partitionId, taskId, options);
    }

    public static Function1<Tuple3<Object, Object, PineconeOptions>, PineconeDataWriter> tupled() {
        return PineconeDataWriter$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<Object, Function1<PineconeOptions, PineconeDataWriter>>> curried() {
        return PineconeDataWriter$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    public int partitionId() {
        return this.partitionId;
    }

    public long taskId() {
        return this.taskId;
    }

    public PineconeOptions options() {
        return this.options;
    }

    private Logger log() {
        return this.log;
    }

    private PineconeConfig config() {
        return this.config;
    }

    private Pinecone pinecone() {
        return this.pinecone;
    }

    private PineconeConnection conn() {
        return this.conn;
    }

    private Map<String, UpsertRequest.Builder> upsertBuilderMap() {
        return this.upsertBuilderMap;
    }

    private void upsertBuilderMap_$eq(Map<String, UpsertRequest.Builder> x$1) {
        this.upsertBuilderMap = x$1;
    }

    private int currentVectorsInBatch() {
        return this.currentVectorsInBatch;
    }

    private void currentVectorsInBatch_$eq(int x$1) {
        this.currentVectorsInBatch = x$1;
    }

    private int totalVectorSize() {
        return this.totalVectorSize;
    }

    private void totalVectorSize_$eq(int x$1) {
        this.totalVectorSize = x$1;
    }

    private int maxBatchSize() {
        return this.maxBatchSize;
    }

    public int totalVectorsWritten() {
        return this.totalVectorsWritten;
    }

    public void totalVectorsWritten_$eq(int x$1) {
        this.totalVectorsWritten = x$1;
    }

    public void write(InternalRow record) {
        try {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            String id = record.getUTF8String(0).toString();
            String namespace = !record.isNullAt(1) ? record.getUTF8String(1).toString() : "";
            ArraySeq.ofRef values = (ArraySeq.ofRef)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.floatArrayOps(record.getArray(2).toFloatArray()), (Function1 & Serializable)x -> Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)x)), ClassTag$.MODULE$.apply(Float.class))).toIterable();
            if (id.length() > package$.MODULE$.MAX_ID_LENGTH()) {
                throw new package.VectorIdTooLongException(id);
            }
            Vector.Builder vectorBuilder = Vector.newBuilder().setId(id);
            Object object = values.nonEmpty() ? vectorBuilder.addAllValues((Iterable)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((Seq)values).asJava()) : BoxedUnit.UNIT;
            if (!record.isNullAt(3)) {
                String metadata = record.getUTF8String(3).toString();
                Struct metadataStruct = package$.MODULE$.parseAndValidateMetadata(id, metadata);
                boxedUnit2 = vectorBuilder.setMetadata(metadataStruct);
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (!record.isNullAt(4)) {
                InternalRow sparseVectorStruct = record.getStruct(4, 2);
                if (!sparseVectorStruct.isNullAt(0) && !sparseVectorStruct.isNullAt(1)) {
                    long[] sparseIndices = sparseVectorStruct.getArray(0).toLongArray();
                    ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.longArrayOps(sparseIndices), (Function1)(JFunction1.mcZJ.sp & Serializable)index -> {
                        if (index < 0L || index > 0xFFFFFFFFL) {
                            throw new IllegalArgumentException(new StringBuilder(59).append("Sparse index ").append(index).append(" is out of range for unsigned 32-bit integers.").toString());
                        }
                        return false;
                    });
                    ArraySeq.ofRef sparseId = (ArraySeq.ofRef)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(sparseIndices), (Function1)(JFunction1.mcIJ.sp & Serializable)x$1 -> (int)x$1, (ClassTag)ClassTag$.MODULE$.Int())), (Function1 & Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Integer.class))).toIterable();
                    ArraySeq.ofRef sparseValues = (ArraySeq.ofRef)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.floatArrayOps(sparseVectorStruct.getArray(1).toFloatArray()), (Function1 & Serializable)x -> Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)x)), ClassTag$.MODULE$.apply(Float.class))).toIterable();
                    SparseValues.Builder sparseDataBuilder = SparseValues.newBuilder().addAllIndices((Iterable)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((Seq)sparseId).asJava()).addAllValues((Iterable)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((Seq)sparseValues).asJava());
                    boxedUnit = vectorBuilder.setSparseValues(sparseDataBuilder.build());
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Vector vector = vectorBuilder.build();
            if (this.currentVectorsInBatch() == this.maxBatchSize() || (double)(this.totalVectorSize() + vector.getSerializedSize()) >= package$.MODULE$.MAX_REQUEST_SIZE()) {
                this.flushBatchToIndex();
            }
            UpsertRequest.Builder builder = (UpsertRequest.Builder)this.upsertBuilderMap().getOrElseUpdate((Object)namespace, (Function0 & Serializable)() -> UpsertRequest.newBuilder().setNamespace(namespace));
            builder.addVectors(vector);
            this.upsertBuilderMap().update((Object)namespace, (Object)builder);
            this.currentVectorsInBatch_$eq(this.currentVectorsInBatch() + 1);
            this.totalVectorSize_$eq(this.totalVectorSize() + vector.getSerializedSize());
        }
        catch (NullPointerException e) {
            this.log().error(new StringBuilder(21).append("Null values in rows: ").append(e.getMessage()).toString());
            throw new package.NullValueException("");
        }
    }

    public WriterCommitMessage commit() {
        this.flushBatchToIndex();
        this.log().debug(new StringBuilder(42).append("taskId=").append(this.taskId()).append(" partitionId=").append(this.partitionId()).append(" totalVectorsUpserted=").append(this.totalVectorsWritten()).toString());
        return new package.PineconeCommitMessage(this.totalVectorsWritten());
    }

    public void abort() {
        this.log().error(new StringBuilder(93).append("PineconeDataWriter(taskId=").append(this.taskId()).append(", partitionId=").append(this.partitionId()).append(") encountered an unhandled error and is shutting down").toString());
        this.cleanup();
    }

    public void close() {
        this.cleanup();
    }

    private void cleanup() {
        this.conn().close();
    }

    private void flushBatchToIndex() {
        this.log().debug(new StringBuilder(35).append("Sending ").append(this.upsertBuilderMap().size()).append(" requests to Pinecone index").toString());
        this.upsertBuilderMap().values().foreach((Function1 & Serializable)builder -> {
            PineconeDataWriter.$anonfun$flushBatchToIndex$1(this, builder);
            return BoxedUnit.UNIT;
        });
        this.log().debug("Upsert operation was successful");
        this.upsertBuilderMap_$eq((Map<String, UpsertRequest.Builder>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.currentVectorsInBatch_$eq(0);
        this.totalVectorSize_$eq(0);
    }

    public PineconeDataWriter copy(int partitionId, long taskId, PineconeOptions options) {
        return new PineconeDataWriter(partitionId, taskId, options);
    }

    public int copy$default$1() {
        return this.partitionId();
    }

    public long copy$default$2() {
        return this.taskId();
    }

    public PineconeOptions copy$default$3() {
        return this.options();
    }

    public String productPrefix() {
        return "PineconeDataWriter";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.partitionId());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.taskId());
                break;
            }
            case 2: {
                object = this.options();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PineconeDataWriter;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "partitionId";
                break;
            }
            case 1: {
                string = "taskId";
                break;
            }
            case 2: {
                string = "options";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.partitionId());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.taskId()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.options()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PineconeDataWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        PineconeDataWriter pineconeDataWriter = (PineconeDataWriter)x$1;
        if (this.partitionId() != pineconeDataWriter.partitionId()) return false;
        if (this.taskId() != pineconeDataWriter.taskId()) return false;
        PineconeOptions pineconeOptions = this.options();
        PineconeOptions pineconeOptions2 = pineconeDataWriter.options();
        if (pineconeOptions == null) {
            if (pineconeOptions2 != null) {
                return false;
            }
        } else if (!pineconeOptions.equals(pineconeOptions2)) return false;
        if (!pineconeDataWriter.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$flushBatchToIndex$1(PineconeDataWriter $this, UpsertRequest.Builder builder) {
        UpsertRequest request = builder.build();
        UpsertResponse response = $this.conn().getBlockingStub().upsert(request);
        $this.log().debug(new StringBuilder(21).append("Upserted ").append(response.getUpsertedCount()).append(" vectors to ").append($this.options().indexName()).toString());
        $this.totalVectorsWritten_$eq($this.totalVectorsWritten() + response.getUpsertedCount());
    }

    public PineconeDataWriter(int partitionId, long taskId, PineconeOptions options) {
        this.partitionId = partitionId;
        this.taskId = taskId;
        this.options = options;
        Product.$init$((Product)this);
        this.log = LoggerFactory.getLogger(this.getClass());
        this.config = new PineconeConfig(options.apiKey());
        this.pinecone = new Pinecone.Builder(options.apiKey()).build();
        this.config().setHost(this.pinecone().describeIndex(options.indexName()).getHost());
        this.conn = new PineconeConnection(this.config());
        this.upsertBuilderMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.currentVectorsInBatch = 0;
        this.totalVectorSize = 0;
        this.maxBatchSize = options.maxBatchSize();
        this.totalVectorsWritten = 0;
    }
}

