/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.spark.pinecone;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.pinecone.spark.pinecone.package;
import java.io.Serializable;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final StructType COMMON_SCHEMA = new StructType().add("id", (DataType)StringType$.MODULE$, false).add("namespace", (DataType)StringType$.MODULE$, true).add("values", (DataType)new ArrayType((DataType)FloatType$.MODULE$, false), false).add("metadata", (DataType)StringType$.MODULE$, true).add("sparse_values", (DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("indices", (DataType)new ArrayType((DataType)LongType$.MODULE$, false), false, StructField$.MODULE$.apply$default$4()), new StructField("values", (DataType)new ArrayType((DataType)FloatType$.MODULE$, false), false, StructField$.MODULE$.apply$default$4())})), true);
    private static final int MAX_ID_LENGTH = 512;
    private static final double MAX_METADATA_SIZE = (double)5 * scala.math.package$.MODULE$.pow(10.0, 3.0);
    private static final double MAX_REQUEST_SIZE = (double)2 * scala.math.package$.MODULE$.pow(10.0, 6.0);

    public StructType COMMON_SCHEMA() {
        return COMMON_SCHEMA;
    }

    public int MAX_ID_LENGTH() {
        return MAX_ID_LENGTH;
    }

    public double MAX_METADATA_SIZE() {
        return MAX_METADATA_SIZE;
    }

    public double MAX_REQUEST_SIZE() {
        return MAX_REQUEST_SIZE;
    }

    public Struct parseAndValidateMetadata(String vectorId, String metadataStr) {
        Struct.Builder structBuilder = Struct.newBuilder();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonTree = mapper.readTree(metadataStr);
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(jsonTree.fields()).asScala()).foreach((Function1 & Serializable)jsonField -> {
            Struct.Builder builder;
            String key = (String)jsonField.getKey();
            JsonNode value = (JsonNode)jsonField.getValue();
            if (value.isTextual()) {
                builder = structBuilder.putFields(key, Value.newBuilder().setStringValue(value.asText()).build());
            } else if (value.isNumber()) {
                builder = structBuilder.putFields(key, Value.newBuilder().setNumberValue((double)value.floatValue()).build());
            } else if (value.isBoolean()) {
                builder = structBuilder.putFields(key, Value.newBuilder().setBoolValue(value.booleanValue()).build());
            } else if (value.isArray() && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(value.elements()).asScala()).toArray(ClassTag$.MODULE$.apply(JsonNode.class))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isTextual()))) {
                JsonNode[] arrayElements = (JsonNode[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(value.elements()).asScala()).toArray(ClassTag$.MODULE$.apply(JsonNode.class));
                ListValue.Builder listValueBuilder = ListValue.newBuilder();
                listValueBuilder.addAllValues((Iterable)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])arrayElements), (Function1 & Serializable)element -> Value.newBuilder().setStringValue(element.textValue()).build(), ClassTag$.MODULE$.apply(Value.class))).toIterable()).asJava());
                builder = structBuilder.putFields(key, Value.newBuilder().setListValue(listValueBuilder.build()).build());
            } else {
                throw new package.InvalidVectorMetadataException(vectorId, key);
            }
            return builder;
        });
        Struct finalStruct = structBuilder.build();
        if ((double)finalStruct.getSerializedSize() >= this.MAX_METADATA_SIZE()) {
            throw new package.PineconeMetadataTooLarge(vectorId);
        }
        return finalStruct;
    }

    private package$() {
    }
}

