/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.boot.scs;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.Map;

public class CfSpringCloudConfigClientProcessor
implements CfEnvProcessor {
    private static final String CONFIG_SERVER_SERVICE_TAG_NAME = "configuration";
    private static final String SPRING_CLOUD_CONFIG_URI = "spring.cloud.config.uri";
    private static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_ID = "spring.cloud.config.client.oauth2.clientId";
    private static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_SECRET = "spring.cloud.config.client.oauth2.clientSecret";
    private static final String SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_ACCESS_TOKEN_URI = "spring.cloud.config.client.oauth2.accessTokenUri";

    public boolean accept(CfService service) {
        return service.existsByTagIgnoreCase(new String[]{CONFIG_SERVER_SERVICE_TAG_NAME});
    }

    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        String uri = cfCredentials.getUri(new String[0]);
        String clientId = cfCredentials.getString(new String[]{"client_id"});
        String clientSecret = cfCredentials.getString(new String[]{"client_secret"});
        String accessTokenUri = cfCredentials.getString(new String[]{"access_token_uri"});
        properties.put(SPRING_CLOUD_CONFIG_URI, uri);
        properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_ID, clientId);
        properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_CLIENT_SECRET, clientSecret);
        properties.put(SPRING_CLOUD_CONFIG_OAUTH2_CLIENT_ACCESS_TOKEN_URI, accessTokenUri);
    }

    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.cloud.config").serviceName("Spring Cloud Config").build();
    }
}

