/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.boot.scs;

import io.pivotal.cfenv.boot.scs.PlainTextConfigClient;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

class PlainTextOAuth2ConfigClient
implements PlainTextConfigClient {
    private final ConfigClientProperties configClientProperties;
    private RestTemplate restTemplate;

    protected PlainTextOAuth2ConfigClient(OAuth2ProtectedResourceDetails resource, ConfigClientProperties configClientProperties) {
        this.restTemplate = new OAuth2RestTemplate(resource);
        this.configClientProperties = configClientProperties;
    }

    @Override
    public Resource getConfigFile(String path) {
        return this.getConfigFile(null, null, path);
    }

    @Override
    public Resource getConfigFile(String profile, String label, String path) {
        Assert.isTrue((this.configClientProperties.getName() != null && !this.configClientProperties.getName().isEmpty() ? 1 : 0) != 0, (String)"Spring application name is undefined.");
        Assert.notEmpty((Object[])this.configClientProperties.getUri(), (String)"Config server URI is undefined");
        Assert.hasText((String)this.configClientProperties.getUri()[0], (String)"Config server URI is undefined.");
        if (profile == null && ((profile = this.configClientProperties.getProfile()) == null || profile.isEmpty())) {
            profile = "default";
        }
        if (label == null) {
            label = this.configClientProperties.getLabel();
        }
        String url = this.configClientProperties.getUri()[0] + "/" + this.configClientProperties.getName() + "/" + profile + "/" + (label == null ? path + "?useDefaultLabel" : label + "/" + path);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, Resource.class, new Object[0]);
        return (Resource)forEntity.getBody();
    }
}

