/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.boot.scs;

import io.pivotal.cfenv.boot.scs.ConfigClientOAuth2ResourceDetails;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnBean(value={ConfigClientProperties.class})
@ConditionalOnProperty(name={"spring.cloud.config.token"})
@EnableScheduling
public class VaultTokenRenewalAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(VaultTokenRenewalAutoConfiguration.class);
    private final RestTemplate rest;
    private final String refreshUri;
    private final HttpEntity<Map<String, Long>> request;
    private final String obscuredToken;
    private final long renewTTL;

    @Autowired
    public VaultTokenRenewalAutoConfiguration(ConfigClientOAuth2ResourceDetails configClientOAuth2ResourceDetails, ConfigClientProperties configClientProps, @Value(value="${spring.cloud.config.token}") String vaultToken, @Value(value="${vault.token.ttl:300000}") long renewTTL) {
        this.rest = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)configClientOAuth2ResourceDetails);
        this.refreshUri = configClientProps.getUri()[0] + "/vault/v1/auth/token/renew-self";
        long renewTTLInMS = renewTTL / 1000L;
        this.request = this.buildTokenRenewRequest(vaultToken, renewTTLInMS);
        this.obscuredToken = vaultToken.substring(0, 4) + "[*]" + vaultToken.substring(vaultToken.length() - 4);
        this.renewTTL = renewTTL;
    }

    @Scheduled(fixedRateString="${vault.token.renew.rate:60000}")
    public void refreshVaultToken() {
        try {
            logger.info("Renewing Vault token " + this.obscuredToken + " for " + this.renewTTL + " milliseconds.");
            this.rest.postForObject(this.refreshUri, this.request, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Unable to renew Vault token " + this.obscuredToken + ". Is the token invalid or expired?");
        }
    }

    private HttpEntity<Map<String, Long>> buildTokenRenewRequest(String vaultToken, long renewTTL) {
        HashMap<String, Long> requestBody = new HashMap<String, Long>();
        requestBody.put("increment", renewTTL);
        HttpHeaders headers = new HttpHeaders();
        headers.set("X-Vault-Token", vaultToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        return request;
    }
}

