/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.boot.scs;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.Map;

public class CfSpringCloudConfigClientProcessor
implements CfEnvProcessor {
    public boolean accept(CfService service) {
        return service.existsByTagIgnoreCase(new String[]{"configuration"});
    }

    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        String uri = cfCredentials.getUri(new String[0]);
        String clientId = cfCredentials.getString(new String[]{"client_id"});
        String clientSecret = cfCredentials.getString(new String[]{"client_secret"});
        String accessTokenUri = cfCredentials.getString(new String[]{"access_token_uri"});
        properties.put("spring.cloud.config.uri", uri);
        properties.put("spring.cloud.config.client.oauth2.clientId", clientId);
        properties.put("spring.cloud.config.client.oauth2.clientSecret", clientSecret);
        properties.put("spring.cloud.config.client.oauth2.accessTokenUri", accessTokenUri);
    }

    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("spring.cloud.config").serviceName("Spring Cloud Config").build();
    }
}

