/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.boot.sso;

import io.pivotal.cfenv.boot.sso.SpringSecurityDetector;
import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.Map;

public class CfSingleSignOnLegacyProcessor
implements CfEnvProcessor {
    private static final String PIVOTAL_SSO_LABEL = "p-identity";

    public boolean accept(CfService service) {
        return SpringSecurityDetector.isLegacySpringSecurityPresent() && service.existsByLabelStartsWith(PIVOTAL_SSO_LABEL);
    }

    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        String clientId = cfCredentials.getString(new String[]{"client_id"});
        String clientSecret = cfCredentials.getString(new String[]{"client_secret"});
        String authDomain = cfCredentials.getString(new String[]{"auth_domain"});
        properties.put("security.oauth2.client.clientId", clientId);
        properties.put("security.oauth2.client.clientSecret", clientSecret);
        properties.put("security.oauth2.client.accessTokenUri", authDomain + "/oauth/token");
        properties.put("security.oauth2.client.userAuthorizationUri", authDomain + "/oauth/authorize");
        properties.put("ssoServiceUrl", authDomain);
        properties.put("security.oauth2.resource.userInfoUri", authDomain + "/userinfo");
        properties.put("security.oauth2.resource.tokenInfoUri", authDomain + "/check_token");
        properties.put("security.oauth2.resource.jwk.key-set-uri", authDomain + "/token_keys");
    }

    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("security.oauth2.client, security.oauth2.resource").serviceName("Single Sign On").build();
    }
}

