/*
 * Decompiled with CFR 0.152.
 */
package io.pixelbin.sdk_kotlin;

import io.pixelbin.sdk_kotlin.TransformationObj;
import io.pixelbin.sdk_kotlin.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lio/pixelbin/sdk_kotlin/Utility;", "", "()V", "getTransformationString", "", "transformation", "Ljava/util/ArrayList;", "Lio/pixelbin/sdk_kotlin/TransformationObj;", "Lkotlin/collections/ArrayList;", "getTransformationValue", "isHexColor", "", "color", "isImageUrlValid", "url", "pixelbin"})
public final class Utility {
    @NotNull
    public static final Utility INSTANCE = new Utility();

    private Utility() {
    }

    @NotNull
    public final String getTransformationString(@NotNull ArrayList<TransformationObj> transformation) {
        Intrinsics.checkNotNullParameter(transformation, (String)"transformation");
        String finalString = "";
        Iterator<TransformationObj> iterator = transformation.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            TransformationObj item = iterator.next();
            finalString = transformation.size() == 1 || index == 0 ? this.getTransformationValue(item) : finalString + "~" + this.getTransformationValue(item);
        }
        return finalString;
    }

    private final String getTransformationValue(TransformationObj transformation) {
        String parametersString2;
        HashMap<String, String> hashMap = transformation.values;
        String string = parametersString2 = hashMap != null && (hashMap = hashMap.entrySet()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)((Object)hashMap)), (CharSequence)",", null, null, (int)0, null, (Function1)getTransformationValue.parametersString.1.INSTANCE, (int)30, null) : null;
        return (string != null ? ((CharSequence)string).length() > 0 : false) ? transformation.plugin + "." + transformation.name + "(" + parametersString2 + ")" : transformation.plugin + "." + transformation.name + "()";
    }

    public final boolean isHexColor(@NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Regex hexColorRegex = new Regex("^#?([0-9A-Fa-f]{3}|[0-9A-Fa-f]{6})$");
        return hexColorRegex.matches((CharSequence)color);
    }

    public final boolean isImageUrlValid(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Regex pattern = new Regex(".*\\.(jpg|jpeg|png|gif)(\\?.*)?$", RegexOption.IGNORE_CASE);
        return pattern.matches((CharSequence)url);
    }
}

