/*
 * Decompiled with CFR 0.152.
 */
package io.pixelbin.sdk_kotlin.upload;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/pixelbin/sdk_kotlin/upload/RetryInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "pixelbin"})
public final class RetryInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response2 = null;
        int retryCount = 0;
        int maxRetries = 3;
        String errorMsg = null;
        do {
            try {
                String exception;
                response2 = chain.proceed(request);
                Response response3 = response2;
                if (response3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                    response3 = null;
                }
                if (response3.isSuccessful() || retryCount >= maxRetries) break;
                ResponseBody responseBody = response2.body();
                String string = exception = responseBody != null ? responseBody.string() : null;
                if (exception == null || !StringsKt.contains$default((CharSequence)exception, (CharSequence)"timeout", (boolean)false, (int)2, null)) break;
                ++retryCount;
            }
            catch (IOException e) {
                String string = e.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"timeout", (boolean)false, (int)2, null) : false;
                if (bl) {
                    errorMsg = "timeout";
                    if (++retryCount != 3) continue;
                    response2 = new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(408).message(errorMsg).body(ResponseBody.Companion.create("", MediaType.Companion.get("application/json"))).build();
                    continue;
                }
                errorMsg = String.valueOf(e.getMessage());
                new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).message(errorMsg).build();
                break;
            }
        } while (retryCount < maxRetries);
        if ((response = response2) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"response");
            response = null;
        }
        return response;
    }
}

