/*
 * Decompiled with CFR 0.152.
 */
package io.pixelbin.sdk_kotlin.upload;

import io.pixelbin.sdk_kotlin.error.PDKInvalidUrlException;
import io.pixelbin.sdk_kotlin.error.PDKTimeoutException;
import io.pixelbin.sdk_kotlin.upload.NetworkUtil;
import io.pixelbin.sdk_kotlin.upload.Result;
import io.pixelbin.sdk_kotlin.upload.SignedDetails;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002JB\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010JJ\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0013JL\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e\u0012\u0004\u0012\u00020\u00070\rH\u0082@\u00a2\u0006\u0002\u0010\u0017JL\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e\u0012\u0004\u0012\u00020\u00070\rH\u0082@\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lio/pixelbin/sdk_kotlin/upload/Upload;", "", "()V", "extractPbuValue", "", "url", "multipartFileUpload", "", "file", "Ljava/io/File;", "signedDetails", "Lio/pixelbin/sdk_kotlin/upload/SignedDetails;", "callback", "Lkotlin/Function1;", "Lio/pixelbin/sdk_kotlin/upload/Result;", "chunkSize", "", "concurrency", "upload", "(Ljava/io/File;Lio/pixelbin/sdk_kotlin/upload/SignedDetails;Lkotlin/jvm/functions/Function1;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadToGCS", "fields", "", "(Ljava/lang/String;Ljava/util/Map;Ljava/io/File;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadToS3", "pixelbin"})
@SourceDebugExtension(value={"SMAP\nUpload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Upload.kt\nio/pixelbin/sdk_kotlin/upload/Upload\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,366:1\n216#2,2:367\n216#2,2:370\n1#3:369\n*S KotlinDebug\n*F\n+ 1 Upload.kt\nio/pixelbin/sdk_kotlin/upload/Upload\n*L\n76#1:367,2\n324#1:370,2\n*E\n"})
public final class Upload {
    @Nullable
    public final Object upload(@NotNull File file, @NotNull SignedDetails signedDetails, @NotNull Function1<? super Result<? extends Object>, Unit> callback, int chunkSize, int concurrency, @NotNull Continuation<? super Unit> $completion) {
        String url = signedDetails.url;
        Map<String, String> fields = signedDetails.fields;
        String string = url;
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)it, (CharSequence)"storage.googleapis.com", (boolean)false, (int)2, null)) {
                Object object = this.uploadToGCS(it, fields, file, callback, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            } else if (StringsKt.contains$default((CharSequence)it, (CharSequence)"api.pixelbin", (boolean)false, (int)2, null)) {
                this.multipartFileUpload(file, signedDetails, callback, chunkSize, concurrency);
            } else {
                Object object = this.uploadToS3(it, fields, file, callback, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object upload$default(Upload upload, File file, SignedDetails signedDetails, Function1 function1, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 1;
        }
        return upload.upload(file, signedDetails, (Function1<? super Result<? extends Object>, Unit>)function1, n, n2, (Continuation<? super Unit>)continuation);
    }

    private final Object uploadToS3(String url, Map<String, String> fields, File file, Function1<? super Result<? extends Object>, Unit> callback, Continuation<? super Unit> $completion) {
        Object object = url;
        if (object == null || object.length() == 0 || (object = fields) == null || object.isEmpty()) {
            throw new Error("Please provide the correct object. Refer upload api docs for details.");
        }
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        Map<String, String> $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            builder.addFormDataPart(key, value);
        }
        MediaType mediaType = MediaType.Companion.parse("application/octet-stream");
        Intrinsics.checkNotNull((Object)mediaType);
        MediaType contentType = mediaType;
        builder.addFormDataPart("file", file.getName(), RequestBody.Companion.create(file, contentType));
        MultipartBody form = builder.build();
        try {
            OkHttpClient client = NetworkUtil.INSTANCE.createOkHttpClient();
            Request request = new Request.Builder().url(url).post((RequestBody)form).build();
            client.newCall(request).enqueue(new Callback(callback){
                final /* synthetic */ Function1<Result<? extends Object>, Unit> $callback;
                {
                    this.$callback = $callback;
                }

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$callback.invoke((Object)new Result.Error(e));
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    if (response.code() == 200 || response.code() == 204) {
                        this.$callback.invoke(new Result.Success<String>(response.message()));
                    } else if (response.code() == 408) {
                        this.$callback.invoke((Object)new Result.Error(new PDKTimeoutException("Request timed out. Please check your internet connection and try again.")));
                    } else {
                        this.$callback.invoke(new Result.Failure<Response>(response));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Unit.INSTANCE;
    }

    public final void multipartFileUpload(@NotNull File file, @NotNull SignedDetails signedDetails, @NotNull Function1<? super Result<? extends Object>, Unit> callback, int chunkSize, int concurrency) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)signedDetails, (String)"signedDetails");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Ref.BooleanRef errorOccurred = new Ref.BooleanRef();
        try {
            int CHUNK_SIZE = 1024 * chunkSize;
            long fileSize = file.length();
            long startTime = System.currentTimeMillis();
            Ref.IntRef partNo = new Ref.IntRef();
            OkHttpClient client = NetworkUtil.INSTANCE.createOkHttpClient();
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, startTime, errorOccurred, partNo, signedDetails, this, client, callback, fileSize, concurrency, CHUNK_SIZE, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                long J$0;
                int I$0;
                int I$1;
                int I$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ File $file;
                final /* synthetic */ long $startTime;
                final /* synthetic */ Ref.BooleanRef $errorOccurred;
                final /* synthetic */ Ref.IntRef $partNo;
                final /* synthetic */ SignedDetails $signedDetails;
                final /* synthetic */ Upload this$0;
                final /* synthetic */ OkHttpClient $client;
                final /* synthetic */ Function1<Result<? extends Object>, Unit> $callback;
                final /* synthetic */ long $fileSize;
                final /* synthetic */ int $concurrency;
                final /* synthetic */ int $CHUNK_SIZE;
                {
                    this.$file = $file;
                    this.$startTime = $startTime;
                    this.$errorOccurred = $errorOccurred;
                    this.$partNo = $partNo;
                    this.$signedDetails = $signedDetails;
                    this.this$0 = $receiver;
                    this.$client = $client;
                    this.$callback = $callback;
                    this.$fileSize = $fileSize;
                    this.$concurrency = $concurrency;
                    this.$CHUNK_SIZE = $CHUNK_SIZE;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            callback.invoke(new Result.Failure<String>(string));
        }
    }

    public static /* synthetic */ void multipartFileUpload$default(Upload upload, File file, SignedDetails signedDetails, Function1 function1, int n, int n2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 1;
        }
        upload.multipartFileUpload(file, signedDetails, (Function1<? super Result<? extends Object>, Unit>)function1, n, n2);
    }

    private final String extractPbuValue(String url) {
        Object object;
        try {
            MatchGroupCollection matchResult;
            Object object2;
            MatchGroupCollection matchGroupCollection;
            Regex regex = new Regex("[?&]pbu=([^&]+)");
            String string = url;
            if (string != null) {
                String it = string;
                boolean bl = false;
                matchGroupCollection = Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null);
            } else {
                matchGroupCollection = null;
            }
            if ((object2 = (matchResult = matchGroupCollection)) == null || (object2 = object2.getGroups()) == null || (object2 = object2.get(1)) == null || (object2 = object2.getValue()) == null) {
                object2 = "";
            }
            object = object2;
        }
        catch (Exception e) {
            throw new PDKInvalidUrlException("Invalid image url");
        }
        return object;
    }

    private final Object uploadToGCS(String url, Map<String, String> fields, File file, Function1<? super Result<? extends Object>, Unit> callback, Continuation<? super Unit> $completion) {
        Object object = url;
        if (object == null || object.length() == 0 || (object = fields) == null || object.isEmpty()) {
            throw new Error("Please provide the correct object. Refer upload api docs for details.");
        }
        Request.Builder requestBuilder = new Request.Builder().url(url);
        Map<String, String> $this$forEach$iv = fields;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            requestBuilder.addHeader(key, value);
        }
        RequestBody requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse("application/octet-stream"));
        requestBuilder.method("PUT", requestBody);
        Request request = requestBuilder.build();
        try {
            OkHttpClient client = NetworkUtil.INSTANCE.createOkHttpClient();
            client.newCall(request).enqueue(new Callback(callback){
                final /* synthetic */ Function1<Result<? extends Object>, Unit> $callback;
                {
                    this.$callback = $callback;
                }

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$callback.invoke((Object)new Result.Error(e));
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    if (response.code() == 200) {
                        this.$callback.invoke(new Result.Success<String>(response.message()));
                    } else if (response.code() == 408) {
                        this.$callback.invoke((Object)new Result.Error(new PDKTimeoutException("Request timed out. Please check your internet connection and try again.")));
                    } else {
                        this.$callback.invoke(new Result.Failure<Response>(response));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$uploadToS3(Upload $this, String url, Map fields, File file, Function1 callback, Continuation $completion) {
        return $this.uploadToS3(url, fields, file, (Function1<? super Result<? extends Object>, Unit>)callback, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ String access$extractPbuValue(Upload $this, String url) {
        return $this.extractPbuValue(url);
    }

    public static final /* synthetic */ Object access$uploadToGCS(Upload $this, String url, Map fields, File file, Function1 callback, Continuation $completion) {
        return $this.uploadToGCS(url, fields, file, (Function1<? super Result<? extends Object>, Unit>)callback, (Continuation<? super Unit>)$completion);
    }
}

