/*
 * Decompiled with CFR 0.152.
 */
package io.pixelbin.sdk_kotlin.url;

import io.pixelbin.sdk_kotlin.TransformationMap;
import io.pixelbin.sdk_kotlin.TransformationObj;
import io.pixelbin.sdk_kotlin.Utility;
import io.pixelbin.sdk_kotlin.error.PDKIllegalStateException;
import io.pixelbin.sdk_kotlin.error.PDKInvalidUrlException;
import io.pixelbin.sdk_kotlin.error.PDKTransformationException;
import io.pixelbin.sdk_kotlin.url.UrlObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B+\b\u0001\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013JL\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0017j\b\u0012\u0004\u0012\u00020\u0013`\u00182\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001aj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u001bH\u0002J\u001e\u0010\u0011\u001a\u00020\u00002\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0017j\b\u0012\u0004\u0012\u00020\u0013`\u0018J4\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00032\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001aj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u0003H\u0002J,\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001aj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u001b2\u0006\u0010!\u001a\u00020\u0003H\u0002J,\u0010\"\u001a\u00020\u00032\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001aj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u001bH\u0002J4\u0010#\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00032\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001aj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u001bH\u0002J\u0006\u0010$\u001a\u00020\u0003J\b\u0010%\u001a\u0004\u0018\u00010\u0005J\u001f\u0010&\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010'R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lio/pixelbin/sdk_kotlin/url/Url;", "", "imgUrl", "", "urlObject", "Lio/pixelbin/sdk_kotlin/url/UrlObj;", "isCustomDomain", "", "(Ljava/lang/String;Lio/pixelbin/sdk_kotlin/url/UrlObj;Ljava/lang/Boolean;)V", "imageUrl", "originalPath", "originalUrl", "urlObj", "getUrlObj", "()Lio/pixelbin/sdk_kotlin/url/UrlObj;", "setUrlObj", "(Lio/pixelbin/sdk_kotlin/url/UrlObj;)V", "addTransformation", "transformation", "Lio/pixelbin/sdk_kotlin/TransformationObj;", "", "transformationName", "transformationList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "list", "addValuesToHashMap", "input", "create", "extractUrlParams", "urlString", "getOptionParamString", "getTransformationObj", "getUrl", "getUrlObject", "setUrlComponents", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "pixelbin"})
@SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\nio/pixelbin/sdk_kotlin/url/Url\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1863#2,2:294\n1#3:296\n*S KotlinDebug\n*F\n+ 1 Url.kt\nio/pixelbin/sdk_kotlin/url/Url\n*L\n74#1:294,2\n*E\n"})
public final class Url {
    @NotNull
    private String imageUrl;
    @NotNull
    private String originalUrl;
    @Nullable
    private UrlObj urlObj;
    @NotNull
    private final String originalPath;

    @JvmOverloads
    public Url(@Nullable String imgUrl, @Nullable UrlObj urlObject, @Nullable Boolean isCustomDomain) {
        this.imageUrl = "";
        this.originalUrl = "";
        this.originalPath = "original/";
        if (imgUrl != null) {
            this.imageUrl = imgUrl;
            this.setUrlComponents(this.imageUrl, isCustomDomain);
            this.originalUrl = this.imageUrl;
        }
        if (urlObject != null) {
            this.urlObj = urlObject;
        }
    }

    public /* synthetic */ Url(String string, UrlObj urlObj, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            urlObj = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, urlObj, bl);
    }

    @Nullable
    public final UrlObj getUrlObj() {
        return this.urlObj;
    }

    public final void setUrlObj(@Nullable UrlObj urlObj) {
        this.urlObj = urlObj;
    }

    private final void setUrlComponents(String imageUrl, Boolean isCustomDomain) {
        try {
            String[] stringArray;
            String[] stringArray2;
            int baseUrlEndIndex = StringsKt.indexOf$default((CharSequence)imageUrl, (String)"/", (int)(StringsKt.indexOf$default((CharSequence)imageUrl, (String)"//", (int)0, (boolean)false, (int)6, null) + 2), (boolean)false, (int)4, null);
            String string = imageUrl.substring(0, baseUrlEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String baseUrl = string;
            String string2 = imageUrl.substring(baseUrlEndIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String remainingUrl = string2;
            String[] stringArray3 = new String[]{"/"};
            List parts = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)remainingUrl, (String[])stringArray3, (boolean)false, (int)0, (int)6, null));
            ArrayList<TransformationObj> transformationList = new ArrayList<TransformationObj>();
            String cloudName = "";
            String[] version = "";
            String zone = "";
            String imagePath = "";
            boolean worker = false;
            String[] workerPath = "";
            String remainingPath = "";
            if (StringsKt.contains$default((CharSequence)imageUrl, (CharSequence)"wrkr", (boolean)false, (int)2, null)) {
                if (parts.size() >= 2 && StringsKt.startsWith$default((String)((String)parts.get(0)), (String)"v", (boolean)false, (int)2, null)) {
                    version = (String)parts.get(0);
                    parts.remove(0);
                    cloudName = (String)parts.get(0);
                    parts.remove(0);
                    if (Intrinsics.areEqual(parts.get(1), (Object)"wrkr")) {
                        zone = (String)parts.get(0);
                        parts.remove(0);
                    }
                    worker = true;
                    remainingPath = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    workerPath = StringsKt.contains$default((CharSequence)remainingPath, (CharSequence)"?", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)remainingPath, (String)"?", null, (int)2, null) : remainingPath;
                    parts.clear();
                }
            } else if (parts.size() >= 2 && StringsKt.startsWith$default((String)((String)parts.get(0)), (String)"v", (boolean)false, (int)2, null)) {
                version = (String)parts.get(0);
                parts.remove(0);
                cloudName = (String)parts.get(0);
                parts.remove(0);
                if (Intrinsics.areEqual(parts.get(1), (Object)"original") || StringsKt.contains$default((CharSequence)((CharSequence)parts.get(1)), (CharSequence)"(", (boolean)false, (int)2, null)) {
                    zone = (String)parts.get(0);
                    parts.remove(0);
                }
                if (parts.size() >= 1 && !Intrinsics.areEqual(parts.get(0), (Object)"original")) {
                    stringArray2 = new String[]{"~"};
                    Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)((CharSequence)parts.get(0)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String transformation = (String)element$iv;
                        boolean bl = false;
                        stringArray = new String[]{"("};
                        String transformationName = (String)StringsKt.split$default((CharSequence)transformation, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
                        if (((Map)TransformationMap.INSTANCE.getHashMap()).containsKey(transformationName)) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            if (StringsKt.contains$default((CharSequence)transformation, (CharSequence)":", (boolean)false, (int)2, null)) {
                                String string3 = transformation.substring(1, transformation.length() - 1);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                this.addValuesToHashMap(string3, map);
                            }
                            this.addTransformation(transformationName, transformationList, map);
                            continue;
                        }
                        throw new PDKInvalidUrlException("invalid image url");
                    }
                }
                parts.remove(0);
                remainingPath = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                imagePath = StringsKt.contains$default((CharSequence)remainingPath, (CharSequence)"?", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)remainingPath, (String)"?", null, (int)2, null) : remainingPath;
                parts.clear();
            }
            stringArray2 = version;
            String string4 = cloudName;
            String string5 = zone;
            String string6 = imagePath;
            HashMap<String, String> hashMap = this.extractUrlParams(remainingPath);
            boolean bl = worker;
            stringArray = workerPath;
            this.urlObj = new UrlObj(baseUrl, (String)stringArray2, string4, transformationList, string5, string6, hashMap, bl, isCustomDomain, (String)stringArray);
        }
        catch (Exception e) {
            throw new PDKInvalidUrlException("invalid image url");
        }
    }

    private final HashMap<String, String> extractUrlParams(String urlString) {
        int queryStartIndex = StringsKt.indexOf$default((CharSequence)urlString, (char)'?', (int)0, (boolean)false, (int)6, null);
        if (queryStartIndex == -1) {
            return new HashMap<String, String>();
        }
        String string = urlString.substring(queryStartIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String query = string;
        HashMap<String, String> params = new HashMap<String, String>();
        String[] stringArray = new String[]{"&"};
        List pairs = StringsKt.split$default((CharSequence)query, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String pair : pairs) {
            String[] stringArray2 = new String[]{"="};
            List keyValue = StringsKt.split$default((CharSequence)pair, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (keyValue.size() != 2) continue;
            String key = (String)keyValue.get(0);
            String value = (String)keyValue.get(1);
            ((Map)params).put(key, value);
        }
        return params;
    }

    private final void addValuesToHashMap(String input, HashMap<String, String> map) {
        Regex regex = new Regex("(\\w+):(.+)");
        Sequence matches = Regex.findAll$default((Regex)regex, (CharSequence)input, (int)0, (int)2, null);
        for (MatchResult match : matches) {
            String string;
            MatchResult.Destructured destructured = match.getDestructured();
            String key = (String)destructured.getMatch().getGroupValues().get(1);
            String value = (String)destructured.getMatch().getGroupValues().get(2);
            Double numericValue = StringsKt.toDoubleOrNull((String)value);
            Float floatValue = StringsKt.toFloatOrNull((String)value);
            Map map2 = map;
            Double d = numericValue;
            if (d != null) {
                string = d.toString();
            } else {
                Float f = floatValue;
                string = f != null ? f.toString() : value;
            }
            map2.put(key, string);
        }
    }

    private final void addTransformation(String transformationName, ArrayList<TransformationObj> transformationList, HashMap<String, String> map) {
        TransformationObj transformationObj = this.getTransformationObj(transformationName, map);
        transformationList.add(transformationObj);
    }

    private final TransformationObj getTransformationObj(String transformationName, HashMap<String, String> map) {
        TransformationObj transformationObj = TransformationMap.INSTANCE.getHashMap().get(transformationName);
        if (transformationObj != null) {
            return TransformationObj.copy$default(transformationObj, null, null, map, 3, null);
        }
        throw new PDKTransformationException("transformation not found in transformationMap");
    }

    @NotNull
    public final Url addTransformation(@NotNull ArrayList<TransformationObj> list) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (this.urlObj == null) {
                throw new PDKIllegalStateException("url object is null.");
            }
            UrlObj urlObj = this.urlObj;
            if (!(urlObj != null ? Intrinsics.areEqual((Object)urlObj.worker, (Object)false) : false) || (object = this.urlObj) == null || (object = ((UrlObj)object).transformation) == null) break block1;
            ((ArrayList)object).addAll((Collection)list);
        }
        return this;
    }

    @NotNull
    public final Url addTransformation(@NotNull TransformationObj transformation) {
        block1: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
            if (this.urlObj == null) {
                throw new PDKIllegalStateException("url is empty .");
            }
            UrlObj urlObj = this.urlObj;
            if (!(urlObj != null ? Intrinsics.areEqual((Object)urlObj.worker, (Object)false) : false) || (object = this.urlObj) == null || (object = ((UrlObj)object).transformation) == null) break block1;
            ((ArrayList)object).add(transformation);
        }
        return this;
    }

    private final String create() {
        Object object;
        block8: {
            block7: {
                String string;
                String string2;
                Object it;
                object = this.urlObj;
                if (object == null) break block7;
                UrlObj $this$create_u24lambda_u242 = object;
                boolean bl = false;
                Object object2 = this.urlObj;
                if (object2 != null && (object2 = ((UrlObj)object2).transformation) != null) {
                    it = object2;
                    boolean bl2 = false;
                    string2 = Utility.INSTANCE.getTransformationString((ArrayList<TransformationObj>)it);
                } else {
                    string2 = null;
                }
                String transformationString = string2;
                CharSequence charSequence = $this$create_u24lambda_u242.zone;
                String zoneValue = charSequence == null || charSequence.length() == 0 ? "" : $this$create_u24lambda_u242.zone + "/";
                Object object3 = this.urlObj;
                Object transValue = (object3 != null && (object3 = ((UrlObj)object3).transformation) != null ? ((ArrayList)object3).isEmpty() : false) ? this.originalPath : transformationString + "/";
                it = $this$create_u24lambda_u242.options;
                if (it == null || it.isEmpty()) {
                    string = "";
                } else {
                    HashMap<String, String> hashMap = $this$create_u24lambda_u242.options;
                    Intrinsics.checkNotNull(hashMap);
                    string = this.getOptionParamString(hashMap);
                }
                String optionValue = string;
                CharSequence charSequence2 = zoneValue;
                String workerFinalPath = charSequence2 == null || charSequence2.length() == 0 ? $this$create_u24lambda_u242.workerPath : "/" + zoneValue + $this$create_u24lambda_u242.workerPath;
                UrlObj urlObj = this.urlObj;
                String string3 = (urlObj != null ? Intrinsics.areEqual((Object)urlObj.worker, (Object)true) : false) ? $this$create_u24lambda_u242.baseUrl + "/" + $this$create_u24lambda_u242.version + "/" + $this$create_u24lambda_u242.cloudName + workerFinalPath : $this$create_u24lambda_u242.baseUrl + "/" + $this$create_u24lambda_u242.version + "/" + $this$create_u24lambda_u242.cloudName + "/" + zoneValue + (String)transValue + $this$create_u24lambda_u242.filePath + optionValue;
                object = string3;
                if (string3 != null) break block8;
            }
            object = "";
        }
        Object transformedUrl = object;
        return transformedUrl;
    }

    private final String getOptionParamString(HashMap<String, String> map) {
        String dpr = map.get("dpr");
        String fAuto = map.get("f_auto");
        return "?dpr=" + dpr + "&f_auto=" + fAuto;
    }

    @Nullable
    public final UrlObj getUrlObject() {
        if (this.urlObj == null) {
            throw new PDKIllegalStateException("UrlObj is null.");
        }
        return this.urlObj;
    }

    @NotNull
    public final String getUrl() {
        return this.create();
    }

    @JvmOverloads
    public Url(@Nullable String imgUrl, @Nullable UrlObj urlObject) {
        this(imgUrl, urlObject, null, 4, null);
    }

    @JvmOverloads
    public Url(@Nullable String imgUrl) {
        this(imgUrl, null, null, 6, null);
    }

    @JvmOverloads
    public Url() {
        this(null, null, null, 7, null);
    }
}

