/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.core.client.JavaScriptObject;
import playn.core.Json;
import playn.core.json.JsonImpl;
import playn.core.json.JsonParserException;
import playn.core.json.JsonSink;
import playn.core.json.JsonTypedArray;

public class HtmlJson
extends JsonImpl
implements Json {
    public Json.Array createArray() {
        return (Json.Array)JavaScriptObject.createArray().cast();
    }

    public Json.Object createObject() {
        return (Json.Object)JavaScriptObject.createObject().cast();
    }

    public Json.Object parse(String json) throws JsonParserException {
        try {
            JavaScriptObject jsonParse = HtmlJson.jsonParse(json);
            if (!HtmlJson.isValueObject(jsonParse)) {
                throw new JsonParserException(null, "Input JSON was not an object", -1, -1, -1);
            }
            HtmlObject object = (HtmlObject)((Object)HtmlJson.unwrap0(jsonParse));
            return object;
        }
        catch (JavaScriptException e) {
            throw new JsonParserException((Exception)((Object)e), "Failed to parse JSON", -1, -1, -1);
        }
    }

    public Json.Array parseArray(String json) throws JsonParserException {
        try {
            JavaScriptObject jsonParse = HtmlJson.jsonParse(json);
            if (!HtmlJson.isValueArray(jsonParse)) {
                throw new JsonParserException(null, "Input JSON was not an array", -1, -1, -1);
            }
            HtmlArray array = (HtmlArray)((Object)HtmlJson.unwrap0(jsonParse));
            return array;
        }
        catch (JavaScriptException e) {
            throw new JsonParserException((Exception)((Object)e), "Failed to parse JSON", -1, -1, -1);
        }
    }

    public boolean isArray(Object o) {
        return HtmlJson.isObjectAnArray(o);
    }

    public boolean isObject(Object o) {
        return HtmlJson.isObjectAnObject(o);
    }

    public static boolean isObjectAnArray(Object o) {
        return o instanceof JavaScriptObject && HtmlJson.isValueArray(HtmlJson.wrap0(o));
    }

    public static boolean isObjectAnObject(Object o) {
        return o instanceof JavaScriptObject && HtmlJson.isValueObject(HtmlJson.wrap0(o));
    }

    private static native String unwrapString0(Object var0);

    private static native boolean isValueArray(Object var0);

    private static native boolean isValueBoolean(Object var0);

    private static native boolean isValueNumber(Object var0);

    private static native boolean isValueObject(Object var0);

    private static native boolean isValueString(Object var0);

    private static native JavaScriptObject jsonParse(String var0);

    private static native Object unwrap0(Object var0);

    private static native boolean unwrapBoolean0(Object var0);

    private static native double unwrapDouble0(Object var0);

    private static native Object wrap0(double var0);

    private static native Object wrap0(boolean var0);

    private static native Object wrap0(Object var0);

    private static Object wrapNative(Object value) {
        if (value == null || value instanceof String) {
            return HtmlJson.wrap0(value);
        }
        if (value instanceof JavaScriptObject) {
            return HtmlJson.wrap0(value);
        }
        if (value instanceof Number) {
            return HtmlJson.wrap0(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return HtmlJson.wrap0((Boolean)value);
        }
        throw new IllegalArgumentException("Invalid JSON type");
    }

    static final class HtmlObject
    extends JavaScriptObject
    implements Json.Object {
        protected HtmlObject() {
        }

        public Json.Array getArray(String key) {
            return this.getArray(key, (Json.Array)null);
        }

        public final Json.Array getArray(String key, Json.Array dflt) {
            return HtmlJson.isValueArray(this.get0(key)) ? (Json.Array)HtmlJson.unwrap0(this.get0(key)) : dflt;
        }

        public boolean getBoolean(String key) {
            return this.getBoolean(key, false);
        }

        public final boolean getBoolean(String key, boolean dflt) {
            return HtmlJson.isValueBoolean(this.get0(key)) ? HtmlJson.unwrapBoolean0(this.get0(key)) : dflt;
        }

        public float getNumber(String key) {
            return (float)this.getDouble(key, 0.0);
        }

        public float getNumber(String key, float dflt) {
            return (float)this.getDouble(key, dflt);
        }

        public double getDouble(String key) {
            return this.getDouble(key, 0.0);
        }

        public final double getDouble(String key, double dflt) {
            return HtmlJson.isValueNumber(this.get0(key)) ? HtmlJson.unwrapDouble0(this.get0(key)) : dflt;
        }

        public int getInt(String key) {
            return (int)this.getDouble(key, 0.0);
        }

        public int getInt(String key, int dflt) {
            return (int)this.getDouble(key, dflt);
        }

        public long getLong(String key) {
            return (long)this.getDouble(key, 0.0);
        }

        public long getLong(String key, long dflt) {
            return (long)this.getDouble(key, dflt);
        }

        public Json.Object getObject(String key) {
            return this.getObject(key, null);
        }

        public final Json.Object getObject(String key, Json.Object dflt) {
            return HtmlJson.isValueObject(this.get0(key)) ? (Json.Object)HtmlJson.unwrap0(this.get0(key)) : dflt;
        }

        public String getString(String key) {
            return this.getString(key, null);
        }

        public final String getString(String key, String dflt) {
            return HtmlJson.isValueString(this.get0(key)) ? (String)HtmlJson.unwrap0(this.get0(key)) : dflt;
        }

        public <T> Json.TypedArray<T> getArray(String key, Class<T> valueType, Json.TypedArray<T> dflt) {
            Json.Array array = this.getArray(key);
            if (array == null) {
                return dflt;
            }
            return new JsonTypedArray(array, valueType);
        }

        public final <T> Json.TypedArray<T> getArray(String key, Class<T> arrayType) {
            return new JsonTypedArray(this.getArray(key), arrayType);
        }

        public final native boolean containsKey(String var1);

        public Json.TypedArray<String> keys() {
            return new JsonTypedArray(this.getNativeKeys(), String.class);
        }

        public boolean isArray(String key) {
            return HtmlJson.isValueArray(this.get0(key));
        }

        public boolean isBoolean(String key) {
            return HtmlJson.isValueBoolean(this.get0(key));
        }

        public native boolean isNull(String var1);

        public boolean isNumber(String key) {
            return HtmlJson.isValueNumber(this.get0(key));
        }

        public boolean isObject(String key) {
            return HtmlJson.isValueObject(this.get0(key));
        }

        public boolean isString(String key) {
            return HtmlJson.isValueString(this.get0(key));
        }

        public Json.Object put(String key, Object value) {
            this.put0(key, HtmlJson.wrapNative(value));
            return this;
        }

        public Json.Object remove(String key) {
            this.remove0(key);
            return this;
        }

        private native void remove0(String var1);

        public <T extends JsonSink<T>> JsonSink<T> write(JsonSink<T> sink) {
            for (String key : this.keys()) {
                JavaScriptObject o = this.get0(key);
                if (o == null || HtmlJson.isValueString(o)) {
                    sink.value(key, HtmlJson.unwrapString0(o));
                    continue;
                }
                if (HtmlJson.isValueArray(o)) {
                    sink.array(key, (Json.Array)o);
                    continue;
                }
                if (HtmlJson.isValueObject(o)) {
                    sink.object(key, (Json.Object)o);
                    continue;
                }
                if (HtmlJson.isValueBoolean(o)) {
                    sink.value(key, this.getBoolean(key));
                    continue;
                }
                if (HtmlJson.isValueNumber(o)) {
                    sink.value(key, (Number)this.getDouble(key));
                    continue;
                }
                throw new IllegalStateException("Invalid value inside JSON object");
            }
            return sink;
        }

        private native JavaScriptObject get0(String var1);

        private native Json.Array getNativeKeys();

        private native void put0(String var1, Object var2);
    }

    static final class HtmlArray
    extends JavaScriptObject
    implements Json.Array {
        protected HtmlArray() {
        }

        public Json.Array add(int index, Object value) {
            if (index > this.length()) {
                this.set0(index, HtmlJson.wrapNative(value));
            } else {
                this.splice0(index, 0, HtmlJson.wrapNative(value));
            }
            return this;
        }

        public Json.Array add(Object value) {
            this.push0(HtmlJson.wrapNative(value));
            return this;
        }

        public Json.Array getArray(int index) {
            return this.getArray(index, (Json.Array)null);
        }

        public final Json.Array getArray(int index, Json.Array dflt) {
            return HtmlJson.isValueArray(this.get0(index)) ? (Json.Array)HtmlJson.unwrap0(this.get0(index)) : dflt;
        }

        public boolean getBoolean(int index) {
            return this.getBoolean(index, false);
        }

        public final boolean getBoolean(int index, boolean dflt) {
            return HtmlJson.isValueBoolean(this.get0(index)) ? HtmlJson.unwrapBoolean0(this.get0(index)) : dflt;
        }

        public float getNumber(int index) {
            return (float)this.getDouble(index, 0.0);
        }

        public float getNumber(int index, float dflt) {
            return (float)this.getDouble(index, dflt);
        }

        public double getDouble(int index) {
            return this.getDouble(index, 0.0);
        }

        public final double getDouble(int index, double dflt) {
            return HtmlJson.isValueNumber(this.get0(index)) ? HtmlJson.unwrapDouble0(this.get0(index)) : dflt;
        }

        public int getInt(int index) {
            return (int)this.getDouble(index, 0.0);
        }

        public int getInt(int index, int dflt) {
            return (int)this.getDouble(index, dflt);
        }

        public long getLong(int index) {
            return (long)this.getDouble(index, 0.0);
        }

        public long getLong(int index, long dflt) {
            return (long)this.getDouble(index, dflt);
        }

        public Json.Object getObject(int index) {
            return this.getObject(index, null);
        }

        public final Json.Object getObject(int index, Json.Object dflt) {
            return HtmlJson.isValueObject(this.get0(index)) ? (Json.Object)HtmlJson.unwrap0(this.get0(index)) : dflt;
        }

        public String getString(int index) {
            return this.getString(index, null);
        }

        public final String getString(int index, String dflt) {
            return HtmlJson.isValueString(this.get0(index)) ? (String)HtmlJson.unwrap0(this.get0(index)) : dflt;
        }

        public final <T> Json.TypedArray<T> getArray(int index, Class<T> arrayType) {
            return new JsonTypedArray(this.getArray(index), arrayType);
        }

        public boolean isArray(int index) {
            return HtmlJson.isValueArray(this.get0(index));
        }

        public boolean isBoolean(int index) {
            return HtmlJson.isValueBoolean(this.get0(index));
        }

        public native boolean isNull(int var1);

        public boolean isNumber(int index) {
            return HtmlJson.isValueNumber(this.get0(index));
        }

        public boolean isObject(int index) {
            return HtmlJson.isValueObject(this.get0(index));
        }

        public boolean isString(int index) {
            return HtmlJson.isValueString(this.get0(index));
        }

        public final native int length();

        private final native Object get0(int var1);

        public Json.Array remove(int index) {
            this.remove0(index);
            return this;
        }

        private native void remove0(int var1);

        public Json.Array set(int index, Object value) {
            this.set0(index, HtmlJson.wrapNative(value));
            return this;
        }

        public <T extends JsonSink<T>> JsonSink<T> write(JsonSink<T> sink) {
            for (int i = 0; i < this.length(); ++i) {
                Object o = this.get0(i);
                if (o == null || HtmlJson.isValueString(o)) {
                    sink.value(HtmlJson.unwrapString0(o));
                    continue;
                }
                if (HtmlJson.isValueArray(o)) {
                    sink.array((Json.Array)o);
                    continue;
                }
                if (HtmlJson.isValueObject(o)) {
                    sink.object((Json.Object)o);
                    continue;
                }
                if (HtmlJson.isValueBoolean(o)) {
                    sink.value(HtmlJson.unwrapBoolean0(o));
                    continue;
                }
                if (HtmlJson.isValueNumber(o)) {
                    sink.value((Number)HtmlJson.unwrapDouble0(o));
                    continue;
                }
                throw new IllegalStateException("Invalid value inside JSON array");
            }
            return sink;
        }

        private native void push0(Object var1);

        private native void set0(int var1, Object var2);

        private native void splice0(int var1, int var2, Object var3);
    }
}

