/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import playn.core.Net;
import playn.html.HtmlWebSocket;
import react.RFuture;
import react.RPromise;

public class HtmlNet
extends Net {
    public Net.WebSocket createWebSocket(String url, Net.WebSocket.Listener listener) {
        return new HtmlWebSocket(url, listener);
    }

    protected RFuture<Net.Response> execute(Net.Builder req) {
        final RPromise result = RPromise.create();
        try {
            XMLHttpRequest xhr = XMLHttpRequest.create();
            xhr.open(req.method(), req.url);
            for (Net.Header header : req.headers) {
                xhr.setRequestHeader(header.name, header.value);
            }
            xhr.setOnReadyStateChange(new ReadyStateChangeHandler(){

                public void onReadyStateChange(final XMLHttpRequest xhr) {
                    if (xhr.getReadyState() == 4) {
                        final String text = xhr.getResponseText();
                        result.succeed((Object)new Net.Response(xhr.getStatus()){

                            public String payloadString() {
                                return text;
                            }

                            public String header(String name) {
                                return xhr.getResponseHeader(name);
                            }

                            public List<String> headers(String name) {
                                List<String> values = super.headers(name);
                                if (!values.isEmpty()) {
                                    return values;
                                }
                                String value = xhr.getResponseHeader(name);
                                return value == null ? values : Collections.singletonList(value);
                            }

                            protected Map<String, List<String>> extractHeaders() {
                                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                                String block = xhr.getAllResponseHeaders();
                                for (String line : block.split("\r\n")) {
                                    int cidx = line.indexOf(":");
                                    if (cidx <= 0) continue;
                                    String name = line.substring(0, cidx);
                                    ArrayList<String> values = (ArrayList<String>)headers.get(name);
                                    if (values == null) {
                                        values = new ArrayList<String>();
                                        headers.put(name, values);
                                    }
                                    values.add(line.substring(cidx + 1).trim());
                                }
                                return headers;
                            }
                        });
                    }
                }
            });
            if (req.isPost()) {
                if (req.payloadBytes != null) {
                    throw new UnsupportedOperationException("Raw bytes not currently supported in HTML5.");
                }
                xhr.setRequestHeader("Content-Type", req.contentType());
                xhr.send(req.payloadString);
            } else {
                xhr.send();
            }
        }
        catch (Throwable t) {
            result.fail(t);
        }
        return result;
    }
}

