/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.core.client.JsArrayNumber;
import playn.core.Path;

class HtmlPath
implements Path {
    private static final int CMD_BEZIER = 3;
    private static final int CMD_CLOSE = 4;
    private static final int CMD_LINE = 1;
    private static final int CMD_MOVE = 0;
    private static final int CMD_QUAD = 2;
    private JsArrayNumber list = (JsArrayNumber)JsArrayNumber.createArray().cast();

    HtmlPath() {
    }

    public Path bezierTo(float c1x, float c1y, float c2x, float c2y, float x, float y) {
        this.list.push(3.0);
        this.list.push((double)c1x);
        this.list.push((double)c1y);
        this.list.push((double)c2x);
        this.list.push((double)c2y);
        this.list.push((double)x);
        this.list.push((double)y);
        return this;
    }

    public Path close() {
        this.list.push(4.0);
        return this;
    }

    public Path lineTo(float x, float y) {
        this.list.push(1.0);
        this.list.push((double)x);
        this.list.push((double)y);
        return this;
    }

    public Path moveTo(float x, float y) {
        this.list.push(0.0);
        this.list.push((double)x);
        this.list.push((double)y);
        return this;
    }

    public Path quadraticCurveTo(float cpx, float cpy, float x, float y) {
        this.list.push(2.0);
        this.list.push((double)cpx);
        this.list.push((double)cpy);
        this.list.push((double)x);
        this.list.push((double)y);
        return this;
    }

    public Path reset() {
        this.list.setLength(0);
        return this;
    }

    void replay(Context2d ctx) {
        ctx.beginPath();
        int len = this.list.length();
        int i = 0;
        double x = 0.0;
        double y = 0.0;
        block7: while (i < len) {
            switch ((int)this.list.get(i++)) {
                case 0: {
                    x = this.list.get(i++);
                    y = this.list.get(i++);
                    ctx.moveTo(x, y);
                    continue block7;
                }
                case 1: {
                    x = this.list.get(i++);
                    y = this.list.get(i++);
                    ctx.lineTo(x, y);
                    continue block7;
                }
                case 2: {
                    double cpx = this.list.get(i++);
                    double cpy = this.list.get(i++);
                    x = this.list.get(i++);
                    y = this.list.get(i++);
                    ctx.quadraticCurveTo(cpx, cpy, x, y);
                    continue block7;
                }
                case 3: {
                    double c1x = this.list.get(i++);
                    double c1y = this.list.get(i++);
                    double c2x = this.list.get(i++);
                    double c2y = this.list.get(i++);
                    x = this.list.get(i++);
                    y = this.list.get(i++);
                    ctx.bezierCurveTo(c1x, c1y, c2x, c2y, x, y);
                    continue block7;
                }
                case 4: {
                    ctx.closePath();
                    continue block7;
                }
            }
            throw new AssertionError((Object)"Corrupt command list");
        }
    }

    float[] getVertices() {
        int len = this.list.length();
        assert (len % 2 == 0);
        float[] vertices = new float[len];
        int v = 0;
        while (v < len) {
            int cmd = (int)this.list.get(v);
            if (v == vertices.length - 2 ? !$assertionsDisabled && cmd != 4 : !$assertionsDisabled && cmd != 0) {
                throw new AssertionError();
            }
            vertices[v] = (float)this.list.get(v + 1);
            vertices[v + 1] = (float)this.list.get(v + 2);
        }
        return vertices;
    }

    void replay(Path path) {
        path.reset();
        int len = this.list.length();
        int i = 0;
        float x = 0.0f;
        float y = 0.0f;
        block7: while (i < len) {
            switch ((int)this.list.get(i++)) {
                case 0: {
                    x = (float)this.list.get(i++);
                    y = (float)this.list.get(i++);
                    path.moveTo(x, y);
                    continue block7;
                }
                case 1: {
                    x = (float)this.list.get(i++);
                    y = (float)this.list.get(i++);
                    path.lineTo(x, y);
                    continue block7;
                }
                case 2: {
                    float cpx = (float)this.list.get(i++);
                    float cpy = (float)this.list.get(i++);
                    x = (float)this.list.get(i++);
                    y = (float)this.list.get(i++);
                    path.quadraticCurveTo(cpx, cpy, x, y);
                    continue block7;
                }
                case 3: {
                    float c1x = (float)this.list.get(i++);
                    float c1y = (float)this.list.get(i++);
                    float c2x = (float)this.list.get(i++);
                    float c2y = (float)this.list.get(i++);
                    x = (float)this.list.get(i++);
                    y = (float)this.list.get(i++);
                    path.bezierTo(c1x, c1y, c2x, c2y, x, y);
                    continue block7;
                }
                case 4: {
                    path.close();
                    continue block7;
                }
            }
            throw new AssertionError((Object)"Corrupt command list");
        }
    }
}

