/*
 * Decompiled with CFR 0.152.
 */
package playn.rebind;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.resources.client.ClientBundleWithLookup;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.ResourcePrototype;
import com.google.gwt.resources.client.TextResource;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;

public class AutoClientBundleGenerator
extends Generator {
    private static final Map<String, String> EXTENSION_MAP = new HashMap();
    private static FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return !file.getName().equals(".svn");
            }
            String extension = AutoClientBundleGenerator.getExtension(file.getName());
            return EXTENSION_MAP.containsKey(extension);
        }
    };
    private static final String WEB_INF_CLASSES = "WEB-INF/classes/";

    private static String getContentType(TreeLogger logger, Resource resource) {
        String name = resource.getPath().toLowerCase();
        int pos = name.lastIndexOf(46);
        String extension = pos == -1 ? "" : name.substring(pos);
        String contentType = EXTENSION_MAP.get(extension);
        if (contentType == null) {
            logger.log(TreeLogger.WARN, "No Content Type mapping for files with '" + extension + "' extension. Please add a mapping to the " + AutoClientBundleGenerator.class.getCanonicalName() + " class.");
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    private static boolean isValidMethodName(String methodName) {
        return methodName.matches("^[a-zA-Z_$][a-zA-Z0-9_$]*$");
    }

    private static String stripExtension(String filename) {
        return filename.replaceFirst("\\.[^.]+$", "");
    }

    private static String getExtension(String filename) {
        return filename.replaceFirst(".*(\\.[^.]+)$", "$1");
    }

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        JClassType userType;
        TypeOracle typeOracle = context.getTypeOracle();
        try {
            userType = typeOracle.getType(typeName);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "Unable to find metadata for type: " + typeName, (Throwable)e);
            throw new UnableToCompleteException();
        }
        String packageName = userType.getPackage().getName();
        String className = userType.getName();
        className = className.replace('.', '_');
        if (userType.isInterface() == null) {
            logger.log(TreeLogger.ERROR, userType.getQualifiedSourceName() + " is not an interface", null);
            throw new UnableToCompleteException();
        }
        ClassSourceFileComposerFactory composerFactory = new ClassSourceFileComposerFactory(packageName, className + "Impl");
        composerFactory.addImplementedInterface(userType.getQualifiedSourceName());
        composerFactory.addImport(ClientBundleWithLookup.class.getName());
        composerFactory.addImport(DataResource.class.getName());
        composerFactory.addImport(GWT.class.getName());
        composerFactory.addImport(ImageResource.class.getName());
        composerFactory.addImport(ResourcePrototype.class.getName());
        composerFactory.addImport(TextResource.class.getName());
        File warDirectory = this.getWarDirectory(logger);
        assert (warDirectory.isDirectory());
        File classesDirectory = new File(warDirectory, WEB_INF_CLASSES);
        assert (classesDirectory.isDirectory());
        File resourcesDirectory = new File(classesDirectory, packageName.replace('.', '/'));
        assert (resourcesDirectory.isDirectory());
        String baseClassesPath = classesDirectory.getPath();
        logger.log(TreeLogger.DEBUG, "baseClassesPath: " + baseClassesPath);
        HashSet<Resource> resources = this.preferMp3(this.getResources(context, userType, fileFilter));
        HashSet<String> methodNames = new HashSet<String>();
        PrintWriter pw = context.tryCreate(logger, packageName, className + "Impl");
        if (pw != null) {
            SourceWriter sw = composerFactory.createSourceWriter(context, pw);
            sw.println("public ResourcePrototype[] getResources() {");
            sw.indent();
            sw.println("return MyBundle.INSTANCE.getResources();");
            sw.outdent();
            sw.println("}");
            sw.println("public ResourcePrototype getResource(String name) {");
            sw.indent();
            sw.println("return MyBundle.INSTANCE.getResource(name);");
            sw.outdent();
            sw.println("}");
            sw.println("static interface MyBundle extends ClientBundleWithLookup {");
            sw.indent();
            sw.println("MyBundle INSTANCE = GWT.create(MyBundle.class);");
            for (Resource resource : resources) {
                String relativePath = resource.getPath();
                String filename = resource.getPath().substring(resource.getPath().lastIndexOf(47) + 1);
                String contentType = AutoClientBundleGenerator.getContentType(logger, resource);
                String methodName = AutoClientBundleGenerator.stripExtension(filename);
                if (!AutoClientBundleGenerator.isValidMethodName(methodName)) {
                    logger.log(TreeLogger.WARN, "Skipping invalid method name (" + methodName + ") due to: " + relativePath);
                    continue;
                }
                if (!methodNames.add(methodName)) {
                    logger.log(TreeLogger.WARN, "Skipping duplicate method name due to: " + relativePath);
                    continue;
                }
                logger.log(TreeLogger.DEBUG, "Generating method for: " + relativePath);
                Class<? extends ResourcePrototype> returnType = this.getResourcePrototype(contentType);
                sw.println();
                if (returnType == DataResource.class) {
                    if (contentType.startsWith("audio/")) {
                        sw.println("@DataResource.DoNotEmbed");
                    } else {
                        sw.println("@DataResource.MimeType(\"" + contentType + "\")");
                    }
                }
                sw.println("@Source(\"" + relativePath + "\")");
                sw.println(returnType.getName() + " " + methodName + "();");
            }
            sw.outdent();
            sw.println("}");
            sw.commit(logger);
        }
        return composerFactory.getCreatedClassName();
    }

    private HashSet<Resource> preferMp3(HashSet<Resource> files) {
        HashMap map = new HashMap();
        for (Resource file : files) {
            String path = AutoClientBundleGenerator.stripExtension(file.getPath());
            if (!file.getPath().endsWith(".mp3") && map.containsKey((Object)path)) continue;
            map.put((Object)path, (Object)file);
        }
        return new HashSet<Resource>(map.values());
    }

    private HashSet<Resource> getResources(GeneratorContext context, JClassType userType, FileFilter filter) {
        String pack = userType.getPackage().getName().replace('.', '/');
        HashSet<Resource> resourceList = new HashSet<Resource>();
        for (String path : context.getResourcesOracle().getPathNames()) {
            String ext;
            if (!path.startsWith(pack) || !EXTENSION_MAP.containsKey(ext = AutoClientBundleGenerator.getExtension(path))) continue;
            resourceList.add(context.getResourcesOracle().getResource(path));
        }
        return resourceList;
    }

    private Class<? extends ResourcePrototype> getResourcePrototype(String contentType) {
        Class returnType = contentType.startsWith("image/") ? ImageResource.class : (contentType.startsWith("text/") ? TextResource.class : DataResource.class);
        return returnType;
    }

    private File getWarDirectory(TreeLogger logger) throws UnableToCompleteException {
        File currentDirectory = new File(".");
        try {
            String canonicalPath = currentDirectory.getCanonicalPath();
            logger.log(TreeLogger.INFO, "Current directory in which this generator is executing: " + canonicalPath);
            if (canonicalPath.endsWith("war")) {
                return currentDirectory;
            }
            return new File("war");
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Failed to get canonical path", (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    static {
        EXTENSION_MAP.put(".png", "image/png");
        EXTENSION_MAP.put(".gif", "image/gif");
        EXTENSION_MAP.put(".jpg", "image/jpeg");
        EXTENSION_MAP.put(".mp3", "audio/mp3");
        EXTENSION_MAP.put(".json", "text/json");
    }
}

