/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.plugin;

import io.polygonal.DiContainer;
import io.polygonal.LanguageRecognizer;
import io.polygonal.Message;
import io.polygonal.plugin.Conditions;
import io.polygonal.plugin.PolygonalArchitecture;
import io.polygonal.verifytask.VerifyTaskAction;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="verifyPolygons", defaultPhase=LifecyclePhase.VERIFY)
public class PolygonalArchitecturePlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(required=true)
    String basePackage;
    @Parameter
    File sourcesDir;
    @Parameter
    File polygonTemplate;
    @Parameter
    boolean strictMode = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        assert (this.project != null) : Message.PACKAGE_REQUIRED;
        if (this.sourcesDir == null) {
            this.sourcesDir = new File(this.project.getBasedir(), "src/main/java");
        }
        if (this.polygonTemplate == null) {
            this.polygonTemplate = new File(this.project.getBasedir(), "src/main/resources/polygon.yml");
        }
        this.getLog().info((CharSequence)Message.USING_TEMPLATE.withArgs(this.polygonTemplate.getPath()));
        Conditions.check(this.polygonTemplate.canRead(), Message.YML_TEMPLATE_NOT_FOUND.msg());
        PolygonalArchitecture polygonalArchitecture = new PolygonalArchitecture();
        polygonalArchitecture.setBasePackage(this.basePackage);
        polygonalArchitecture.setSourcesDir(this.sourcesDir);
        polygonalArchitecture.setPolygonTemplate(this.polygonTemplate);
        polygonalArchitecture.setStrictMode(this.strictMode);
        DiContainer.initialize(LanguageRecognizer.recognize(this.project));
        this.getLog().info((CharSequence)Message.CHECKING_POLYGONS.withArgs(this.project.getArtifactId()));
        new VerifyTaskAction().accept(polygonalArchitecture, this.project);
    }
}

