/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import io.polygonal.Message;
import io.polygonal.plugin.Conditions;
import io.polygonal.plugin.PackageDef;
import io.polygonal.verifytask.ReflectionHelper;
import io.polygonal.verifytask.TypesValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class MapToPackageDefListConverter {
    private static final String TYPE_FIELD = "type";

    private MapToPackageDefListConverter() {
    }

    static List<PackageDef> convertToPackageDefinitions(Map<String, Object> defsMap, Map<String, String> keywordsDictionary) {
        ArrayList<PackageDef> buffer = new ArrayList<PackageDef>();
        defsMap.forEach((packageName, value) -> MapToPackageDefListConverter.convertToPackageDef(packageName, (Map)defsMap.get(packageName), keywordsDictionary, buffer));
        return buffer;
    }

    private static void convertToPackageDef(String name, Map<String, Object> mapData, Map<String, String> keywordsDictionary, List<PackageDef> buffer) {
        PackageDef packageDef = new PackageDef();
        mapData.put("name", name);
        mapData.forEach((key, value) -> {
            String newKey = keywordsDictionary.getOrDefault(key, (String)key);
            if (newKey.equals(TYPE_FIELD)) {
                TypesValidator.validate(value);
            }
            if (!keywordsDictionary.containsKey(key)) {
                Conditions.check(value instanceof Map, Message.NOT_KEYWORD_FIELD_SHOULD_BE_MAP.withArgs(key));
                MapToPackageDefListConverter.convertToPackageDef(MessageFormat.format("{0}.{1}", name, key).replaceAll("^\\.", ""), (Map)value, keywordsDictionary, buffer);
            } else {
                ReflectionHelper.set(packageDef, newKey, value);
            }
        });
        buffer.add(packageDef);
    }
}

