/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import io.polygonal.plugin.PackageDef;
import io.polygonal.verifytask.DirectoryToPackageNameConverter;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class PackagesIntoMapSplitter {
    private PackagesIntoMapSplitter() {
    }

    static Map<File, PackageDef> splitPackagesIntoMap(File rootLevel, List<PackageDef> packageDefExtensions) {
        HashMap<File, PackageDef> defExtensionMap = new HashMap<File, PackageDef>();
        if (packageDefExtensions.isEmpty()) {
            return defExtensionMap;
        }
        ArrayList<PackageDef> sourcePackageDefExtensions = new ArrayList<PackageDef>(packageDefExtensions);
        Optional<PackageDef> rootLevelDef = sourcePackageDefExtensions.stream().filter(packageDef -> "".equals(packageDef.getName())).findAny();
        rootLevelDef.ifPresent(packageDef -> defExtensionMap.put(rootLevel, (PackageDef)packageDef));
        Files.walk(rootLevel.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::toFile).forEach(dir -> {
            Optional<PackageDef> packageDef = PackagesIntoMapSplitter.findPackageDef(rootLevel, dir, sourcePackageDefExtensions);
            packageDef.ifPresent(def -> defExtensionMap.put((File)dir, (PackageDef)def));
        });
        return defExtensionMap;
    }

    private static Optional<PackageDef> findPackageDef(File rootDir, File dir, List<PackageDef> packageDefs) {
        String dirPackageName = DirectoryToPackageNameConverter.convertToPackageName(rootDir, dir);
        return packageDefs.stream().filter(p -> dirPackageName.equals(p.getName())).findAny();
    }
}

