/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import io.polygonal.DiContainer;
import io.polygonal.Message;
import io.polygonal.plugin.Polygon;
import io.polygonal.plugin.PolygonalArchitecture;
import io.polygonal.verifytask.RecursivePackagesVerifier;
import io.polygonal.verifytask.YmlPolygonDefinition;
import java.io.File;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;

public class VerifyTaskAction
implements BiConsumer<PolygonalArchitecture, MavenProject> {
    @Override
    public void accept(PolygonalArchitecture polygonalArchitecture, MavenProject mavenProject) {
        Polygon polygon = new YmlPolygonDefinition(polygonalArchitecture.getPolygonTemplate()).asPolygon();
        File baseDir = new File(polygonalArchitecture.getSourcesDir(), polygonalArchitecture.getBasePackage().replace(".", File.separator));
        RecursivePackagesVerifier packagesVerifier = DiContainer.get(RecursivePackagesVerifier.class);
        SystemStreamLog log = new SystemStreamLog();
        ((Stream)Stream.of((Object[])Objects.requireNonNull(baseDir.listFiles(File::isDirectory))).parallel()).forEach(dir -> {
            log.info((CharSequence)Message.CHECK_POLYGON.withArgs(dir.getName()));
            packagesVerifier.verify((File)dir, polygon.getPackagesDefs());
        });
    }
}

