/*
 * Decompiled with CFR 0.152.
 */
package io.polygonal.verifytask;

import com.google.common.collect.ImmutableMap;
import io.polygonal.Message;
import io.polygonal.plugin.Conditions;
import io.polygonal.plugin.PackageDef;
import io.polygonal.plugin.Polygon;
import io.polygonal.verifytask.MapToPackageDefListConverter;
import io.polygonal.verifytask.ReflectionHelper;
import io.polygonal.verifytask.TypesValidator;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

class YmlPolygonDefinition {
    private static final String POLYGON_EXTENSION = "polygon";
    private static final String PACKAGES = "packages";
    private static final String YML_EXTENSION = ".yml";
    static final Map<String, String> KEYWORDS_MAP = ImmutableMap.builder().put((Object)"public", (Object)"publicScope").put((Object)"packagePrivate", (Object)"packagePrivateScope").put((Object)"protected", (Object)"protectedScope").put((Object)"internal", (Object)"internalScope").put((Object)"types", (Object)"types").put((Object)"required", (Object)"required").put((Object)"name", (Object)"name").build();
    private final File file;

    YmlPolygonDefinition(File file) {
        if (file == null || !file.exists() || !Files.isReadable(file.toPath())) {
            throw new IllegalArgumentException(Message.YML_TEMPLATE_NOT_FOUND.withArgs(file != null ? file.getPath() : ""));
        }
        if (!file.getName().endsWith(YML_EXTENSION)) {
            throw new IllegalArgumentException(Message.TEMPLATE_IS_NOT_YML_FILE.withArgs(file.getName()));
        }
        this.file = file;
    }

    public Polygon asPolygon() {
        ArrayList<PackageDef> extensions = new ArrayList<PackageDef>();
        PackageDef rootPackageDef = new PackageDef("");
        Map<String, Object> polygonMap = this.getPolygonMapFromYML(this.file, rootPackageDef);
        extensions.add(rootPackageDef);
        if (polygonMap.containsKey(PACKAGES)) {
            Conditions.check(polygonMap.get(PACKAGES) instanceof Map, Message.TEMPLATE_PACKAGES_SHOULD_CONTAIN_PACKAGES_DEFINITIONS.toString());
            List<PackageDef> packagesDefinitions = MapToPackageDefListConverter.convertToPackageDefinitions((Map)polygonMap.get(PACKAGES), KEYWORDS_MAP);
            extensions.addAll(packagesDefinitions);
        }
        return new Polygon(extensions);
    }

    private Map<String, Object> getPolygonMapFromYML(File ymlFile, PackageDef rootPackageDef) {
        Map ymlMap = (Map)new Yaml().loadAs(new String(Files.readAllBytes(ymlFile.toPath())), Map.class);
        Conditions.check(ymlMap.containsKey(POLYGON_EXTENSION), Message.TEMPLATE_CANNOT_FIND_POLYGON.withArgs(POLYGON_EXTENSION, ymlFile.getName()));
        Map polygonMap = (Map)ymlMap.get(POLYGON_EXTENSION);
        polygonMap.forEach((key, value) -> {
            if (KEYWORDS_MAP.containsKey(key)) {
                ReflectionHelper.set(rootPackageDef, KEYWORDS_MAP.get(key), value);
            }
        });
        TypesValidator.validate(rootPackageDef.getTypes());
        return polygonMap;
    }
}

