/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.hash.RandomFactory;
import io.pravega.common.util.BitConverter;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.BufferViewComparator;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import lombok.Generated;

public abstract class AttributeId
implements Comparable<AttributeId> {
    public static final int MAX_LENGTH = 256;

    public static AttributeId uuid(long mostSignificantBits, long leastSignificantBits) {
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public static AttributeId fromUUID(java.util.UUID uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static AttributeId from(byte[] data) {
        return new Variable(data);
    }

    @VisibleForTesting
    public static AttributeId randomUUID() {
        return AttributeId.fromUUID(java.util.UUID.randomUUID());
    }

    @VisibleForTesting
    public static AttributeId random(int length) {
        Preconditions.checkArgument((length > 0 && length <= 256 ? 1 : 0) != 0, (String)"length must be a positive number less than or equal to %s.", (int)256);
        byte[] result = new byte[length];
        RandomFactory.create().nextBytes(result);
        return AttributeId.from(result);
    }

    public abstract boolean isUUID();

    public abstract int byteCount();

    public abstract long getBitGroup(int var1);

    public abstract ByteArraySegment toBuffer();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public abstract int compareTo(AttributeId var1);

    public static final class Variable
    extends AttributeId {
        private static final BufferViewComparator COMPARATOR = BufferViewComparator.create();
        private final byte[] data;
        private final int hashCode;

        private Variable(byte[] data) {
            this.data = data;
            this.hashCode = (int)BufferView.wrap((byte[])this.data).hash();
        }

        @Override
        public boolean isUUID() {
            return false;
        }

        @Override
        public int byteCount() {
            return this.data.length;
        }

        @Override
        public long getBitGroup(int position) {
            return BitConverter.readLong((byte[])this.data, (int)(position << 3));
        }

        @Override
        public ByteArraySegment toBuffer() {
            return new ByteArraySegment(this.data);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Variable) {
                return Arrays.equals(this.data, ((Variable)obj).data);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public int compareTo(AttributeId val) {
            return COMPARATOR.compare(this.data, ((Variable)val).data);
        }

        public String toString() {
            return String.format("Length = %s, Hashcode = %s", this.data.length, this.hashCode);
        }

        public static AttributeId minValue(int length) {
            return new Variable(BufferViewComparator.getMinValue((int)length));
        }

        public static AttributeId maxValue(int length) {
            return new Variable(BufferViewComparator.getMaxValue((int)length));
        }
    }

    public static final class UUID
    extends AttributeId {
        public static final int ATTRIBUTE_ID_LENGTH = 16;
        private final long mostSignificantBits;
        private final long leastSignificantBits;

        @Override
        public boolean isUUID() {
            return true;
        }

        @Override
        public int byteCount() {
            return 16;
        }

        @Override
        public long getBitGroup(int position) {
            switch (position) {
                case 0: {
                    return this.mostSignificantBits;
                }
                case 1: {
                    return this.leastSignificantBits;
                }
            }
            throw new IllegalArgumentException(this.getClass().getName() + " only supports bit groups 0 and 1. Requested: " + position);
        }

        public java.util.UUID toUUID() {
            return new java.util.UUID(this.mostSignificantBits, this.leastSignificantBits);
        }

        @Override
        public ByteArraySegment toBuffer() {
            ByteArraySegment result = new ByteArraySegment(new byte[16]);
            result.setLong(0, this.mostSignificantBits);
            result.setLong(8, this.leastSignificantBits);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof UUID) {
                UUID id = (UUID)obj;
                return this.mostSignificantBits == id.mostSignificantBits && this.leastSignificantBits == id.leastSignificantBits;
            }
            return false;
        }

        @Override
        public int hashCode() {
            long hash = this.mostSignificantBits ^ this.leastSignificantBits;
            return (int)(hash >> 32) ^ (int)hash;
        }

        @Override
        public int compareTo(AttributeId val) {
            UUID uuid = (UUID)val;
            int r = Long.compare(this.mostSignificantBits, uuid.mostSignificantBits);
            if (r == 0) {
                r = Long.compare(this.leastSignificantBits, uuid.leastSignificantBits);
            }
            return r;
        }

        public String toString() {
            return this.toUUID().toString();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getMostSignificantBits() {
            return this.mostSignificantBits;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLeastSignificantBits() {
            return this.leastSignificantBits;
        }

        @ConstructorProperties(value={"mostSignificantBits", "leastSignificantBits"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private UUID(long mostSignificantBits, long leastSignificantBits) {
            this.mostSignificantBits = mostSignificantBits;
            this.leastSignificantBits = leastSignificantBits;
        }
    }
}

