/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import java.beans.ConstructorProperties;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
public class AttributeUpdate {
    private final AttributeId attributeId;
    private final AttributeUpdateType updateType;
    private long value;
    private final long comparisonValue;

    public AttributeUpdate(AttributeId attributeId, AttributeUpdateType updateType, long value) {
        this(attributeId, updateType, value, Long.MIN_VALUE);
        Preconditions.checkArgument((updateType != AttributeUpdateType.ReplaceIfEquals ? 1 : 0) != 0, (Object)"Cannot use this constructor with ReplaceIfEquals.");
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeUpdate) {
            AttributeUpdate other = (AttributeUpdate)obj;
            return this.attributeId.equals(other.attributeId) && this.updateType == other.updateType && this.value == other.value && this.comparisonValue == other.comparisonValue;
        }
        return false;
    }

    public int hashCode() {
        return this.attributeId.hashCode();
    }

    public String toString() {
        if (this.updateType == AttributeUpdateType.ReplaceIfEquals) {
            return String.format("AttributeId = %s, UpdateType = %s, Value = %s, Compare = %s", new Object[]{this.attributeId, this.updateType, this.value, this.comparisonValue});
        }
        return String.format("AttributeId = %s, UpdateType = %s, Value = %s", new Object[]{this.attributeId, this.updateType, this.value});
    }

    @ConstructorProperties(value={"attributeId", "updateType", "value", "comparisonValue"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AttributeUpdate(AttributeId attributeId, AttributeUpdateType updateType, long value, long comparisonValue) {
        this.attributeId = attributeId;
        this.updateType = updateType;
        this.value = value;
        this.comparisonValue = comparisonValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AttributeId getAttributeId() {
        return this.attributeId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AttributeUpdateType getUpdateType() {
        return this.updateType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getValue() {
        return this.value;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getComparisonValue() {
        return this.comparisonValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setValue(long value) {
        this.value = value;
    }
}

