/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.DynamicAttributeUpdate;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;

public class AttributeUpdateCollection
extends AbstractCollection<AttributeUpdate>
implements Collection<AttributeUpdate> {
    private final ArrayList<AttributeUpdate> uuidAttributes = new ArrayList();
    private final ArrayList<AttributeUpdate> variableAttributes = new ArrayList();
    private final ArrayList<DynamicAttributeUpdate> dynamic = new ArrayList();
    private Integer extendedAttributeIdLength = null;

    public static AttributeUpdateCollection from(Iterable<AttributeUpdate> attributeUpdates) {
        AttributeUpdateCollection c = new AttributeUpdateCollection();
        attributeUpdates.forEach(c::add);
        return c;
    }

    public static AttributeUpdateCollection from(AttributeUpdate ... attributeUpdates) {
        AttributeUpdateCollection c = new AttributeUpdateCollection();
        for (AttributeUpdate au : attributeUpdates) {
            c.add(au);
        }
        return c;
    }

    public boolean hasVariableAttributeIds() {
        return this.variableAttributes.size() > 0;
    }

    public Collection<AttributeUpdate> getVariableAttributeUpdates() {
        return Collections.unmodifiableCollection(this.variableAttributes);
    }

    public Collection<AttributeUpdate> getUUIDAttributeUpdates() {
        return Collections.unmodifiableCollection(this.uuidAttributes);
    }

    public Collection<DynamicAttributeUpdate> getDynamicAttributeUpdates() {
        return Collections.unmodifiableCollection(this.dynamic);
    }

    @Override
    public boolean add(AttributeUpdate au) {
        if (!Attributes.isCoreAttribute(au.getAttributeId())) {
            int length = au.getAttributeId().isUUID() ? 0 : au.getAttributeId().byteCount();
            Preconditions.checkArgument((this.extendedAttributeIdLength == null || this.extendedAttributeIdLength == length ? 1 : 0) != 0, (String)"All Extended Attribute Ids must have the same type and length. Expected length %s, Attribute Update = '%s'.", (Object)this.extendedAttributeIdLength, (Object)au);
            this.extendedAttributeIdLength = length;
        }
        if (au.getAttributeId().isUUID()) {
            this.uuidAttributes.add(au);
        } else {
            this.variableAttributes.add(au);
        }
        if (au.isDynamic()) {
            this.dynamic.add((DynamicAttributeUpdate)au);
        }
        return true;
    }

    @Override
    public Iterator<AttributeUpdate> iterator() {
        return Iterators.concat(this.uuidAttributes.iterator(), this.variableAttributes.iterator());
    }

    @Override
    public int size() {
        return this.uuidAttributes.size() + this.variableAttributes.size();
    }

    @Override
    @VisibleForTesting
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection other = (Collection)o;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator<AttributeUpdate> thisIterator = this.iterator();
        Iterator otherIterator = other.iterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            if (thisIterator.next().equals(otherIterator.next())) continue;
            return false;
        }
        return !thisIterator.hasNext() && !otherIterator.hasNext();
    }

    @Override
    @VisibleForTesting
    public int hashCode() {
        int hashCode = 1;
        for (AttributeUpdate e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getExtendedAttributeIdLength() {
        return this.extendedAttributeIdLength;
    }
}

