/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts;

import io.pravega.segmentstore.contracts.AttributeId;
import java.util.Map;
import java.util.stream.Collectors;

public class Attributes {
    public static final long BOOLEAN_TRUE = 1L;
    public static final long BOOLEAN_FALSE = 0L;
    public static final long TABLE_ATTRIBUTES_START_OFFSET = 0x100000L;
    public static final long NULL_ATTRIBUTE_VALUE = Long.MIN_VALUE;
    public static final long CORE_ATTRIBUTE_ID_PREFIX = Long.MIN_VALUE;
    public static final AttributeId CREATION_TIME = AttributeId.uuid(Long.MIN_VALUE, 0L);
    public static final AttributeId EVENT_COUNT = AttributeId.uuid(Long.MIN_VALUE, 1L);
    public static final AttributeId SCALE_POLICY_TYPE = AttributeId.uuid(Long.MIN_VALUE, 2L);
    public static final AttributeId SCALE_POLICY_RATE = AttributeId.uuid(Long.MIN_VALUE, 3L);
    public static final AttributeId ROLLOVER_SIZE = AttributeId.uuid(Long.MIN_VALUE, 4L);
    private static final AttributeId RETIRED_1 = AttributeId.uuid(Long.MIN_VALUE, 5L);
    private static final AttributeId RETIRED_2 = AttributeId.uuid(Long.MIN_VALUE, 6L);
    public static final AttributeId ATTRIBUTE_SEGMENT_ROOT_POINTER = AttributeId.uuid(Long.MIN_VALUE, 7L);
    public static final AttributeId ATTRIBUTE_SEGMENT_PERSIST_SEQ_NO = AttributeId.uuid(Long.MIN_VALUE, 8L);
    public static final AttributeId ATTRIBUTE_SEGMENT_TYPE = AttributeId.uuid(Long.MIN_VALUE, 9L);
    public static final AttributeId ATTRIBUTE_SLTS_LATEST_SNAPSHOT_ID = AttributeId.uuid(Long.MIN_VALUE, 10L);
    public static final AttributeId ATTRIBUTE_SLTS_LATEST_SNAPSHOT_EPOCH = AttributeId.uuid(Long.MIN_VALUE, 11L);
    public static final AttributeId ATTRIBUTE_ID_LENGTH = AttributeId.uuid(Long.MIN_VALUE, 12L);
    public static final AttributeId CREATION_EPOCH = AttributeId.uuid(Long.MIN_VALUE, 15L);

    public static boolean isUnmodifiable(AttributeId attributeId) {
        return attributeId == ATTRIBUTE_SEGMENT_TYPE || attributeId == ATTRIBUTE_ID_LENGTH;
    }

    public static boolean isCoreAttribute(AttributeId attributeId) {
        return attributeId.isUUID() && attributeId.getBitGroup(0) == Long.MIN_VALUE;
    }

    public static Map<AttributeId, Long> getCoreNonNullAttributes(Map<AttributeId, Long> attributes) {
        return attributes.entrySet().stream().filter(e -> Attributes.isCoreAttribute((AttributeId)e.getKey()) && (Long)e.getValue() != Long.MIN_VALUE).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

