/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.contracts.tables.ConditionalTableUpdateException;
import io.pravega.segmentstore.contracts.tables.TableKey;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class BadKeyVersionException
extends ConditionalTableUpdateException {
    private static final long serialVersionUID = 1L;
    private final Map<TableKey, Long> expectedVersions;

    public BadKeyVersionException(String segmentName, Map<TableKey, Long> expectedVersions) {
        super(segmentName, String.format("Version mismatch for %s key(s): %s.", expectedVersions.size(), BadKeyVersionException.getMessage(expectedVersions)));
        this.expectedVersions = expectedVersions;
    }

    private static String getMessage(Map<TableKey, Long> expectedVersions) {
        return expectedVersions.entrySet().stream().map(e -> String.format("%s (%s)", e.getValue(), ((TableKey)e.getKey()).getVersion())).collect(Collectors.joining(", "));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<TableKey, Long> getExpectedVersions() {
        return this.expectedVersions;
    }
}

