/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.contracts.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.tables.TableKey;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

public class TableEntry {
    private final TableKey key;
    private final BufferView value;

    public static TableEntry unversioned(@NonNull BufferView key, @NonNull BufferView value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new TableEntry(TableKey.unversioned(key), value);
    }

    public static TableEntry notExists(@NonNull BufferView key, @NonNull BufferView value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new TableEntry(TableKey.notExists(key), value);
    }

    public static TableEntry notExists(@NonNull BufferView key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new TableEntry(TableKey.notExists(key), null);
    }

    public static TableEntry versioned(@NonNull BufferView key, @NonNull BufferView value, long version) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new TableEntry(TableKey.versioned(key, version), value);
    }

    public String toString() {
        return String.format("%s -> %s", this.key, this.value);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableEntry) {
            TableEntry other = (TableEntry)obj;
            return this.key.equals(other.key) && (this.value == null && other.value == null || this.value != null && other.value != null && this.value.equals(other.getValue()));
        }
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableKey getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BufferView getValue() {
        return this.value;
    }

    @ConstructorProperties(value={"key", "value"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private TableEntry(TableKey key, BufferView value) {
        this.key = key;
        this.value = value;
    }
}

