/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.auth.JKSHelper;
import io.pravega.common.auth.ZKTLSUtils;
import io.pravega.segmentstore.storage.impl.bookkeeper.ZooKeeperServiceRunner;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperServiceRunner
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(BookKeeperServiceRunner.class);
    public static final String PROPERTY_BASE_PORT = "basePort";
    public static final String PROPERTY_BOOKIE_COUNT = "bookieCount";
    public static final String PROPERTY_ZK_PORT = "zkPort";
    public static final String PROPERTY_LEDGERS_PATH = "ledgersPath";
    public static final String PROPERTY_START_ZK = "startZk";
    public static final String PROPERTY_SECURE_BK = "secureBk";
    public static final String TLS_KEY_STORE_PASSWD = "tlsKeyStorePasswd";
    public static final String TLS_KEY_STORE = "tlsKeyStore";
    private static final InetAddress LOOPBACK_ADDRESS = InetAddress.getLoopbackAddress();
    private final boolean startZk;
    private final int zkPort;
    private final String ledgersPath;
    private final boolean secureBK;
    private final String tLSKeyStore;
    private final String tLSKeyStorePasswordPath;
    private final boolean secureZK;
    private final String tlsTrustStore;
    private final List<Integer> bookiePorts;
    private final List<BookieServer> servers = new ArrayList<BookieServer>();
    private final AtomicReference<ZooKeeperServiceRunner> zkServer = new AtomicReference();
    private final HashMap<Integer, File> tempDirs = new HashMap();
    private final AtomicReference<Thread> cleanup = new AtomicReference();

    @Override
    public void close() throws Exception {
        try {
            this.servers.stream().filter(Objects::nonNull).forEach(BookieServer::shutdown);
            if (this.zkServer.get() != null) {
                this.zkServer.get().close();
            }
        }
        finally {
            this.cleanupDirectories();
        }
        Thread c = this.cleanup.getAndSet(null);
        if (c != null) {
            Runtime.getRuntime().removeShutdownHook(c);
        }
    }

    private void cleanupOnShutdown() {
        this.close();
    }

    public void stopBookie(int bookieIndex) {
        Preconditions.checkState((this.servers.size() > 0 ? 1 : 0) != 0, (Object)"No Bookies initialized. Call startAll().");
        Preconditions.checkState((this.servers.get(0) != null ? 1 : 0) != 0, (Object)"Bookie already stopped.");
        BookieServer bk = this.servers.get(bookieIndex);
        bk.shutdown();
        this.servers.set(bookieIndex, null);
        log.info("Bookie {} stopped.", (Object)bookieIndex);
    }

    public void startBookie(int bookieIndex) throws Exception {
        Preconditions.checkState((this.servers.size() > 0 ? 1 : 0) != 0, (Object)"No Bookies initialized. Call startAll().");
        Preconditions.checkState((this.servers.get(0) == null ? 1 : 0) != 0, (Object)"Bookie already running.");
        this.servers.set(bookieIndex, this.runBookie(this.bookiePorts.get(bookieIndex)));
        log.info("Bookie {} stopped.", (Object)bookieIndex);
    }

    public void suspendZooKeeper() {
        ZooKeeperServiceRunner zk = this.zkServer.get();
        Preconditions.checkState((zk != null ? 1 : 0) != 0, (Object)"ZooKeeper not started.");
        zk.stop();
        log.info("ZooKeeper suspended.");
    }

    public void resumeZooKeeper() throws Exception {
        ZooKeeperServiceRunner zk = new ZooKeeperServiceRunner(this.zkPort, this.secureZK, this.tLSKeyStore, this.tLSKeyStorePasswordPath, this.tlsTrustStore);
        if (this.zkServer.compareAndSet(null, zk)) {
            zk.initialize();
            log.info("ZooKeeper initialized.");
        } else {
            zk.close();
        }
        this.zkServer.get().start();
        log.info("ZooKeeper resumed.");
    }

    public void startAll() throws Exception {
        this.cleanup.set(new Thread(this::cleanupOnShutdown));
        Runtime.getRuntime().addShutdownHook(this.cleanup.get());
        if (this.startZk) {
            this.resumeZooKeeper();
        }
        this.initializeZookeeper();
        this.runBookies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeZookeeper() throws Exception {
        log.info("Formatting ZooKeeper ...");
        if (this.secureZK) {
            ZKTLSUtils.setSecureZKClientProperties((String)this.tlsTrustStore, (String)JKSHelper.loadPasswordFrom((String)this.tLSKeyStorePasswordPath));
        } else {
            ZKTLSUtils.unsetSecureZKClientProperties();
        }
        ZooKeeperClient zkc = ZooKeeperClient.newBuilder().connectString(LOOPBACK_ADDRESS.getHostAddress() + ":" + this.zkPort).sessionTimeoutMs(10000).build();
        try {
            StringBuilder znodePath = new StringBuilder();
            for (String z : this.ledgersPath.split("/")) {
                znodePath.append(z);
                String znode = znodePath.toString();
                if (!znode.isEmpty()) {
                    zkc.create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                znodePath.append("/");
            }
            znodePath.append("available");
            zkc.create(znodePath.toString(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        finally {
            if (Collections.singletonList(zkc).get(0) != null) {
                zkc.close();
            }
        }
    }

    private void runBookies() throws Exception {
        log.info("Starting Bookie(s) ...");
        for (int bkPort : this.bookiePorts) {
            this.servers.add(this.runBookie(bkPort));
        }
    }

    private BookieServer runBookie(int bkPort) throws Exception {
        File tmpDir = this.tempDirs.getOrDefault(bkPort, null);
        if (tmpDir == null) {
            tmpDir = IOUtils.createTempDir((String)("bookie_" + bkPort), (String)"test");
            tmpDir.deleteOnExit();
            this.tempDirs.put(bkPort, tmpDir);
            log.info("Created " + tmpDir);
            if (!tmpDir.delete() || !tmpDir.mkdir()) {
                throw new IOException("Couldn't create bookie dir " + tmpDir);
            }
        }
        ServerConfiguration conf = new ServerConfiguration();
        conf.setBookiePort(bkPort);
        conf.setMetadataServiceUri("zk://" + LOOPBACK_ADDRESS.getHostAddress() + ":" + this.zkPort + this.ledgersPath);
        conf.setJournalDirName(tmpDir.getPath());
        conf.setLedgerDirNames(new String[]{tmpDir.getPath()});
        conf.setAllowLoopback(true);
        conf.setJournalAdaptiveGroupWrites(false);
        if (this.secureBK) {
            conf.setTLSProvider("OpenSSL");
            conf.setTLSProviderFactoryClass("org.apache.bookkeeper.tls.TLSContextFactory");
            conf.setTLSKeyStore(this.tLSKeyStore);
            conf.setTLSKeyStorePasswordPath(this.tLSKeyStorePasswordPath);
        }
        log.info("Starting Bookie at port " + bkPort);
        BookieServer bs = new BookieServer(conf);
        bs.start();
        return bs;
    }

    private void cleanupDirectories() throws IOException {
        for (File dir : this.tempDirs.values()) {
            log.info("Cleaning up " + dir);
            FileUtils.deleteDirectory((File)dir);
        }
        this.tempDirs.clear();
    }

    public static void main(String[] args) throws Exception {
        BookKeeperServiceRunnerBuilder b = BookKeeperServiceRunner.builder();
        b.startZk(false);
        try {
            int bkBasePort = Integer.parseInt(System.getProperty(PROPERTY_BASE_PORT));
            int bkCount = Integer.parseInt(System.getProperty(PROPERTY_BOOKIE_COUNT));
            ArrayList<Integer> bkPorts = new ArrayList<Integer>();
            for (int i = 0; i < bkCount; ++i) {
                bkPorts.add(bkBasePort + i);
            }
            b.bookiePorts(bkPorts);
            b.zkPort(Integer.parseInt(System.getProperty(PROPERTY_ZK_PORT)));
            b.ledgersPath(System.getProperty(PROPERTY_LEDGERS_PATH));
            b.startZk(Boolean.parseBoolean(System.getProperty(PROPERTY_START_ZK, "false")));
            b.tLSKeyStore(System.getProperty(TLS_KEY_STORE, "../../../config/bookie.keystore.jks"));
            b.tLSKeyStorePasswordPath(System.getProperty(TLS_KEY_STORE_PASSWD, "../../../config/bookie.keystore.jks.passwd"));
            b.secureBK(Boolean.parseBoolean(System.getProperty(PROPERTY_SECURE_BK, "false")));
        }
        catch (Exception ex) {
            System.out.println(String.format("Invalid or missing arguments (via system properties). Expected: %s(int), %s(int), %s(int), %s(String). (%s).", PROPERTY_BASE_PORT, PROPERTY_BOOKIE_COUNT, PROPERTY_ZK_PORT, PROPERTY_LEDGERS_PATH, ex.getMessage()));
            System.exit(-1);
            return;
        }
        BookKeeperServiceRunner runner = b.build();
        runner.startAll();
        Thread.sleep(Long.MAX_VALUE);
    }

    @ConstructorProperties(value={"startZk", "zkPort", "ledgersPath", "secureBK", "tLSKeyStore", "tLSKeyStorePasswordPath", "secureZK", "tlsTrustStore", "bookiePorts"})
    @SuppressFBWarnings(justification="generated code")
    BookKeeperServiceRunner(boolean startZk, int zkPort, String ledgersPath, boolean secureBK, String tLSKeyStore, String tLSKeyStorePasswordPath, boolean secureZK, String tlsTrustStore, List<Integer> bookiePorts) {
        this.startZk = startZk;
        this.zkPort = zkPort;
        this.ledgersPath = ledgersPath;
        this.secureBK = secureBK;
        this.tLSKeyStore = tLSKeyStore;
        this.tLSKeyStorePasswordPath = tLSKeyStorePasswordPath;
        this.secureZK = secureZK;
        this.tlsTrustStore = tlsTrustStore;
        this.bookiePorts = bookiePorts;
    }

    @SuppressFBWarnings(justification="generated code")
    public static BookKeeperServiceRunnerBuilder builder() {
        return new BookKeeperServiceRunnerBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class BookKeeperServiceRunnerBuilder {
        @SuppressFBWarnings(justification="generated code")
        private boolean startZk;
        @SuppressFBWarnings(justification="generated code")
        private int zkPort;
        @SuppressFBWarnings(justification="generated code")
        private String ledgersPath;
        @SuppressFBWarnings(justification="generated code")
        private boolean secureBK;
        @SuppressFBWarnings(justification="generated code")
        private String tLSKeyStore;
        @SuppressFBWarnings(justification="generated code")
        private String tLSKeyStorePasswordPath;
        @SuppressFBWarnings(justification="generated code")
        private boolean secureZK;
        @SuppressFBWarnings(justification="generated code")
        private String tlsTrustStore;
        @SuppressFBWarnings(justification="generated code")
        private List<Integer> bookiePorts;

        @SuppressFBWarnings(justification="generated code")
        BookKeeperServiceRunnerBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder startZk(boolean startZk) {
            this.startZk = startZk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder zkPort(int zkPort) {
            this.zkPort = zkPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder ledgersPath(String ledgersPath) {
            this.ledgersPath = ledgersPath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder secureBK(boolean secureBK) {
            this.secureBK = secureBK;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder tLSKeyStore(String tLSKeyStore) {
            this.tLSKeyStore = tLSKeyStore;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder tLSKeyStorePasswordPath(String tLSKeyStorePasswordPath) {
            this.tLSKeyStorePasswordPath = tLSKeyStorePasswordPath;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder secureZK(boolean secureZK) {
            this.secureZK = secureZK;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder tlsTrustStore(String tlsTrustStore) {
            this.tlsTrustStore = tlsTrustStore;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunnerBuilder bookiePorts(List<Integer> bookiePorts) {
            this.bookiePorts = bookiePorts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BookKeeperServiceRunner build() {
            return new BookKeeperServiceRunner(this.startZk, this.zkPort, this.ledgersPath, this.secureBK, this.tLSKeyStore, this.tLSKeyStorePasswordPath, this.secureZK, this.tlsTrustStore, this.bookiePorts);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "BookKeeperServiceRunner.BookKeeperServiceRunnerBuilder(startZk=" + this.startZk + ", zkPort=" + this.zkPort + ", ledgersPath=" + this.ledgersPath + ", secureBK=" + this.secureBK + ", tLSKeyStore=" + this.tLSKeyStore + ", tLSKeyStorePasswordPath=" + this.tLSKeyStorePasswordPath + ", secureZK=" + this.secureZK + ", tlsTrustStore=" + this.tlsTrustStore + ", bookiePorts=" + this.bookiePorts + ")";
        }
    }
}

