/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.CloseableIterator;
import io.pravega.segmentstore.storage.DataLogInitializationException;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.LogAddress;
import io.pravega.segmentstore.storage.QueueStats;
import io.pravega.segmentstore.storage.ThrottleSourceListener;
import io.pravega.segmentstore.storage.WriteSettings;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperLog;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;
import io.pravega.segmentstore.storage.impl.bookkeeper.Ledgers;
import io.pravega.segmentstore.storage.impl.bookkeeper.LogMetadata;
import io.pravega.segmentstore.storage.impl.bookkeeper.LogReader;
import io.pravega.segmentstore.storage.impl.bookkeeper.ReadOnlyLogMetadata;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.curator.framework.CuratorFramework;

public class DebugLogWrapper
implements AutoCloseable {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final BookKeeperLog log;
    private final BookKeeper bkClient;
    private final BookKeeperConfig config;
    private final AtomicBoolean initialized;

    DebugLogWrapper(int logId, CuratorFramework zkClient, BookKeeper bookKeeper, BookKeeperConfig config, ScheduledExecutorService executor) {
        this.log = new BookKeeperLog(logId, zkClient, bookKeeper, config, executor);
        this.bkClient = bookKeeper;
        this.config = config;
        this.initialized = new AtomicBoolean();
    }

    @Override
    public void close() {
        this.log.close();
    }

    public DurableDataLog asReadOnly() throws DataLogInitializationException {
        return new ReadOnlyBooKeeperLog(this.log.loadMetadata());
    }

    public ReadOnlyLogMetadata fetchMetadata() throws DataLogInitializationException {
        return this.log.loadMetadata();
    }

    public LedgerHandle openLedgerNoFencing(LedgerMetadata ledgerMetadata) throws DurableDataLogException {
        return Ledgers.openRead(ledgerMetadata.getLedgerId(), this.bkClient, this.config);
    }

    public void enable() throws DurableDataLogException {
        this.log.enable();
    }

    public void disable() throws DurableDataLogException {
        this.initialize();
        this.log.disable();
    }

    private void initialize() throws DurableDataLogException {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                this.log.initialize(DEFAULT_TIMEOUT);
            }
            catch (Exception ex) {
                this.initialized.set(false);
                throw ex;
            }
        }
    }

    private class ReadOnlyBooKeeperLog
    implements DurableDataLog {
        private final LogMetadata logMetadata;

        public void close() {
        }

        public CloseableIterator<DurableDataLog.ReadItem, DurableDataLogException> getReader() throws DurableDataLogException {
            return new LogReader(this.logMetadata, DebugLogWrapper.this.bkClient, DebugLogWrapper.this.config);
        }

        public WriteSettings getWriteSettings() {
            return new WriteSettings(1047552, Duration.ofMillis(((Integer)BookKeeperConfig.BK_WRITE_TIMEOUT.getDefaultValue()).intValue()), ((Integer)BookKeeperConfig.MAX_OUTSTANDING_BYTES.getDefaultValue()).intValue());
        }

        public long getEpoch() {
            return this.logMetadata.getEpoch();
        }

        public QueueStats getQueueStatistics() {
            return null;
        }

        public void registerQueueStateChangeListener(ThrottleSourceListener listener) {
            throw new UnsupportedOperationException();
        }

        public void initialize(Duration timeout) throws DurableDataLogException {
            throw new UnsupportedOperationException();
        }

        public void enable() throws DurableDataLogException {
            throw new UnsupportedOperationException();
        }

        public void disable() throws DurableDataLogException {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<LogAddress> append(ArrayView data, Duration timeout) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Void> truncate(LogAddress upToAddress, Duration timeout) {
            throw new UnsupportedOperationException();
        }

        @ConstructorProperties(value={"logMetadata"})
        @SuppressFBWarnings(justification="generated code")
        private ReadOnlyBooKeeperLog(LogMetadata logMetadata) {
            this.logMetadata = logMetadata;
        }
    }
}

