/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.CloseableIterator;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerAddress;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;
import io.pravega.segmentstore.storage.impl.bookkeeper.Ledgers;
import io.pravega.segmentstore.storage.impl.bookkeeper.LogMetadata;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class LogReader
implements CloseableIterator<DurableDataLog.ReadItem, DurableDataLogException> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(LogReader.class);
    private final BookKeeper bookKeeper;
    private final LogMetadata metadata;
    private final AtomicBoolean closed;
    private final BookKeeperConfig config;
    private ReadLedger currentLedger;

    LogReader(LogMetadata metadata, BookKeeper bookKeeper, BookKeeperConfig config) {
        this.metadata = (LogMetadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.bookKeeper = (BookKeeper)Preconditions.checkNotNull((Object)bookKeeper, (Object)"bookKeeper");
        this.config = (BookKeeperConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.closed = new AtomicBoolean();
    }

    public void close() {
        if (!this.closed.getAndSet(true) && this.currentLedger != null) {
            try {
                Ledgers.close(this.currentLedger.handle);
            }
            catch (DurableDataLogException bkEx) {
                log.error("Unable to close LedgerHandle for Ledger {}.", (Object)this.currentLedger.handle.getId(), (Object)bkEx);
            }
            this.currentLedger = null;
        }
    }

    public DurableDataLog.ReadItem getNext() throws DurableDataLogException {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        if (this.currentLedger == null) {
            this.openNextLedger(this.metadata.getNextAddress(this.metadata.getTruncationAddress(), Long.MAX_VALUE));
        }
        while (this.currentLedger != null && !this.currentLedger.canRead()) {
            LedgerAddress lastAddress = new LedgerAddress(this.currentLedger.metadata, this.currentLedger.handle.getLastAddConfirmed());
            Ledgers.close(this.currentLedger.handle);
            this.openNextLedger(this.metadata.getNextAddress(lastAddress, this.currentLedger.handle.getLastAddConfirmed()));
        }
        if (this.currentLedger == null || this.currentLedger.reader == null) {
            return null;
        }
        return new ReadItem(this.currentLedger.reader.nextElement(), this.currentLedger.metadata);
    }

    private void openNextLedger(LedgerAddress address) throws DurableDataLogException {
        if (address == null) {
            this.close();
            return;
        }
        LedgerMetadata metadata = this.metadata.getLedger(address.getLedgerId());
        assert (metadata != null) : "no LedgerMetadata could be found with valid LedgerAddress " + address;
        List<LedgerMetadata> allMetadatas = this.metadata.getLedgers();
        LedgerHandle ledger = allMetadatas.size() == 0 || metadata == allMetadatas.get(allMetadatas.size() - 1) ? Ledgers.openRead(metadata.getLedgerId(), this.bookKeeper, this.config) : Ledgers.openFence(metadata.getLedgerId(), this.bookKeeper, this.config);
        long lastEntryId = ledger.getLastAddConfirmed();
        if (lastEntryId < address.getEntryId()) {
            Ledgers.close(ledger);
            this.currentLedger = new ReadLedger(metadata, ledger, null);
            return;
        }
        try {
            Enumeration reader = (Enumeration)Exceptions.handleInterruptedCall(() -> ledger.readEntries(address.getEntryId(), lastEntryId));
            ReadLedger previousLedger = this.currentLedger;
            this.currentLedger = new ReadLedger(metadata, ledger, reader);
            if (previousLedger != null) {
                Ledgers.close(previousLedger.handle);
            }
        }
        catch (Exception ex) {
            Ledgers.close(ledger);
            this.close();
            throw new DurableDataLogException("Error while reading from BookKeeper.", (Throwable)ex);
        }
    }

    private static class ReadLedger {
        final LedgerMetadata metadata;
        final LedgerHandle handle;
        final Enumeration<LedgerEntry> reader;

        boolean canRead() {
            return this.reader != null && this.reader.hasMoreElements();
        }

        @ConstructorProperties(value={"metadata", "handle", "reader"})
        @SuppressFBWarnings(justification="generated code")
        public ReadLedger(LedgerMetadata metadata, LedgerHandle handle, Enumeration<LedgerEntry> reader) {
            this.metadata = metadata;
            this.handle = handle;
            this.reader = reader;
        }
    }

    private static class ReadItem
    implements DurableDataLog.ReadItem {
        private final InputStream payload;
        private final int length;
        private final LedgerAddress address;

        ReadItem(LedgerEntry entry, LedgerMetadata ledgerMetadata) {
            this.address = new LedgerAddress(ledgerMetadata, entry.getEntryId());
            this.payload = entry.getEntryInputStream();
            this.length = this.payload.available();
        }

        public String toString() {
            return String.format("%s, Length = %d.", this.address, this.length);
        }

        @SuppressFBWarnings(justification="generated code")
        public InputStream getPayload() {
            return this.payload;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getLength() {
            return this.length;
        }

        @SuppressFBWarnings(justification="generated code")
        public LedgerAddress getAddress() {
            return this.address;
        }
    }
}

