/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.TimeoutTimer;
import io.pravega.common.auth.JKSHelper;
import io.pravega.common.auth.ZKTLSUtils;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.LocalBookKeeper;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServiceRunner
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperServiceRunner.class);
    public static final String PROPERTY_ZK_PORT = "zkPort";
    private static final String PROPERTY_SECURE_ZK = "secureZK";
    private static final String PROPERTY_ZK_KEY_STORE = "zkKeyStore";
    private static final String PROPERTY_ZK_KEY_STORE_PASSWORD_PATH = "zkKeyStorePasswordPath";
    private static final String PROPERTY_ZK_TRUST_STORE = "zkTrustStore";
    private static final String LOOPBACK_ADDRESS = "localhost";
    private final AtomicReference<ZooKeeperServer> server = new AtomicReference();
    private final AtomicReference<ServerCnxnFactory> serverFactory = new AtomicReference();
    private final int zkPort;
    private final boolean secureZK;
    private final String keyStore;
    private final String keyStorePasswordPath;
    private final String trustStore;
    private final AtomicReference<File> tmpDir = new AtomicReference();

    @Override
    public void close() throws Exception {
        this.stop();
        File t = this.tmpDir.getAndSet(null);
        if (t != null) {
            log.info("Cleaning up " + t);
            FileUtils.deleteDirectory((File)t);
        }
    }

    public void initialize() throws IOException {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        if (this.tmpDir.compareAndSet(null, IOUtils.createTempDir((String)"zookeeper", (String)"inproc"))) {
            this.tmpDir.get().deleteOnExit();
        }
        if (this.secureZK) {
            ZKTLSUtils.setSecureZKServerProperties((String)this.keyStore, (String)this.keyStorePasswordPath, (String)this.trustStore, (String)this.keyStorePasswordPath);
        }
    }

    public void start() throws Exception {
        Preconditions.checkState((this.tmpDir.get() != null ? 1 : 0) != 0, (Object)"Not Initialized.");
        ZooKeeperServer s = new ZooKeeperServer(this.tmpDir.get(), this.tmpDir.get(), 3000);
        if (!this.server.compareAndSet(null, s)) {
            s.shutdown();
            throw new IllegalStateException("Already started.");
        }
        this.serverFactory.set(NettyServerCnxnFactory.createFactory());
        String address = "localhost:" + this.zkPort;
        log.info("Starting Zookeeper server at " + address + " ...");
        this.serverFactory.get().configure(new InetSocketAddress(LOOPBACK_ADDRESS, this.zkPort), 1000, this.secureZK);
        this.serverFactory.get().startup(s);
        if (!ZooKeeperServiceRunner.waitForServerUp(this.zkPort, this.secureZK, this.keyStore, this.keyStorePasswordPath, this.trustStore, this.keyStorePasswordPath)) {
            throw new IllegalStateException("ZooKeeper server failed to start");
        }
    }

    public void stop() {
        try {
            ServerCnxnFactory sf = this.serverFactory.getAndSet(null);
            if (sf != null) {
                sf.closeAll();
                sf.shutdown();
            }
        }
        catch (Throwable e) {
            log.warn("Unable to cleanly shutdown ZooKeeper connection factory", e);
        }
        try {
            ZooKeeperServer zs = this.server.getAndSet(null);
            if (zs != null) {
                zs.shutdown();
                ZKDatabase zkDb = zs.getZKDatabase();
                if (zkDb != null) {
                    zkDb.close();
                }
            }
        }
        catch (Throwable e) {
            log.warn("Unable to cleanly shutdown ZooKeeper server", e);
        }
        if (this.secureZK) {
            ZKTLSUtils.unsetSecureZKServerProperties();
        }
    }

    private static boolean waitForServerUp(int zkPort, boolean secureZk, String keyStore, String keyStorePasswordPath, String trustStore, String trustStorePasswordPath) {
        String address = "localhost:" + zkPort;
        if (secureZk) {
            return ZooKeeperServiceRunner.waitForSSLServerUp(address, 30000L, keyStore, keyStorePasswordPath, trustStore, trustStorePasswordPath);
        }
        return LocalBookKeeper.waitForServerUp((String)address, (long)30000L);
    }

    public static boolean waitForServerUp(int zkPort) {
        return ZooKeeperServiceRunner.waitForServerUp(zkPort, false, "", "", "", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitForSSLServerUp(String address, long timeout, String keyStore, String keyStorePasswdPath, String trustStore, String trustStorePasswordPath) {
        TimeoutTimer timeoutTimer = new TimeoutTimer(Duration.ofMillis(timeout));
        String[] split = address.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                TrustManagerFactory trustManager = ZooKeeperServiceRunner.getTrustManager(trustStore, trustStorePasswordPath);
                KeyManagerFactory keyFactory = ZooKeeperServiceRunner.getKeyManager(keyStore, keyStorePasswdPath);
                context.init(keyFactory.getKeyManagers(), trustManager.getTrustManagers(), null);
                try (Socket sock = context.getSocketFactory().createSocket(new Socket(host, port), host, port, true);
                     OutputStream outstream = sock.getOutputStream();){
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        log.info("Server UP");
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                log.warn("server  {} not up.", (Object)address, (Object)e);
            }
            if (!timeoutTimer.hasRemaining()) {
                return false;
            }
            Exceptions.handleInterrupted(() -> Thread.sleep(250L));
        }
    }

    private static TrustManagerFactory getTrustManager(String trustStore, String trustStorePasswordPath) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        try (FileInputStream myKeys = new FileInputStream(trustStore);){
            KeyStore myTrustStore = KeyStore.getInstance("JKS");
            myTrustStore.load(myKeys, JKSHelper.loadPasswordFrom((String)trustStorePasswordPath).toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(myTrustStore);
            TrustManagerFactory trustManagerFactory = tmf;
            return trustManagerFactory;
        }
    }

    private static KeyManagerFactory getKeyManager(String keyStore, String keyStorePasswordPath) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyManagerFactory kmf = null;
        try (FileInputStream myKeys = new FileInputStream(keyStore);){
            KeyStore myKeyStore = KeyStore.getInstance("JKS");
            myKeyStore.load(myKeys, JKSHelper.loadPasswordFrom((String)keyStorePasswordPath).toCharArray());
            kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(myKeyStore, JKSHelper.loadPasswordFrom((String)keyStorePasswordPath).toCharArray());
            KeyManagerFactory keyManagerFactory = kmf;
            return keyManagerFactory;
        }
    }

    public static void main(String[] args) throws Exception {
        String zkTrustStore;
        String zkKeyStorePasswdPath;
        String zkKeyStore;
        boolean secureZK;
        int zkPort;
        try {
            zkPort = Integer.parseInt(System.getProperty(PROPERTY_ZK_PORT));
            secureZK = Boolean.parseBoolean(System.getProperty(PROPERTY_SECURE_ZK, "false"));
            zkKeyStore = System.getProperty(PROPERTY_ZK_KEY_STORE);
            zkKeyStorePasswdPath = System.getProperty(PROPERTY_ZK_KEY_STORE_PASSWORD_PATH);
            zkTrustStore = System.getProperty(PROPERTY_ZK_TRUST_STORE);
        }
        catch (Exception ex) {
            System.out.println(String.format("Invalid or missing arguments (via system properties). Expected: %s(int). (%s)", PROPERTY_ZK_PORT, ex.getMessage()));
            System.exit(-1);
            return;
        }
        ZooKeeperServiceRunner runner = new ZooKeeperServiceRunner(zkPort, secureZK, zkKeyStore, zkKeyStorePasswdPath, zkTrustStore);
        runner.initialize();
        runner.start();
        Thread.sleep(Long.MAX_VALUE);
    }

    @ConstructorProperties(value={"zkPort", "secureZK", "keyStore", "keyStorePasswordPath", "trustStore"})
    @SuppressFBWarnings(justification="generated code")
    public ZooKeeperServiceRunner(int zkPort, boolean secureZK, String keyStore, String keyStorePasswordPath, String trustStore) {
        this.zkPort = zkPort;
        this.secureZK = secureZK;
        this.keyStore = keyStore;
        this.keyStorePasswordPath = keyStorePasswordPath;
        this.trustStore = trustStore;
    }
}

