/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.rocksdb;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.Cache;
import io.pravega.segmentstore.storage.CacheFactory;
import io.pravega.segmentstore.storage.impl.rocksdb.RocksDBCache;
import io.pravega.segmentstore.storage.impl.rocksdb.RocksDBConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBCacheFactory
implements CacheFactory {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(RocksDBCacheFactory.class);
    private static final String LOG_ID = "RocksDBCacheFactory";
    private final HashMap<String, RocksDBCache> caches;
    private final RocksDBConfig config;
    private final AtomicBoolean closed;

    public RocksDBCacheFactory(RocksDBConfig config) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        this.config = config;
        this.caches = new HashMap();
        this.closed = new AtomicBoolean();
        RocksDB.loadLibrary();
        log.info("{}: Initialized.", (Object)LOG_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed.get()) {
            ArrayList<RocksDBCache> toClose;
            HashMap<String, RocksDBCache> hashMap = this.caches;
            synchronized (hashMap) {
                toClose = new ArrayList<RocksDBCache>(this.caches.values());
            }
            toClose.forEach(RocksDBCache::close);
            this.closed.set(true);
            log.info("{}: Closed.", (Object)LOG_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String id) {
        RocksDBCache result;
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        boolean isNew = false;
        HashMap<String, RocksDBCache> hashMap = this.caches;
        synchronized (hashMap) {
            result = this.caches.get(id);
            if (result == null) {
                result = new RocksDBCache(id, this.config, this::cacheClosed);
                this.caches.put(id, result);
                isNew = true;
            }
        }
        if (isNew) {
            result.initialize();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheClosed(String cacheId) {
        HashMap<String, RocksDBCache> hashMap = this.caches;
        synchronized (hashMap) {
            this.caches.remove(cacheId);
        }
    }
}

