/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.rocksdb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;

public class RocksDBConfig {
    public static final Property<String> DATABASE_DIR = Property.named((String)"dbDir", (Object)"/tmp/pravega/cache");
    public static final Property<Integer> WRITE_BUFFER_SIZE_MB = Property.named((String)"writeBufferSizeMB", (Object)64);
    public static final Property<Integer> READ_CACHE_SIZE_MB = Property.named((String)"readCacheSizeMB", (Object)8);
    public static final Property<Integer> CACHE_BLOCK_SIZE_KB = Property.named((String)"cacheBlockSizeKB", (Object)32);
    public static final Property<Boolean> DIRECT_READS = Property.named((String)"directReads", (Object)false);
    public static final Property<Boolean> MEM_ONLY = Property.named((String)"memoryOnly", (Object)false);
    private static final String COMPONENT_CODE = "rocksdb";
    private final String databaseDir;
    private final int writeBufferSizeMB;
    private final int readCacheSizeMB;
    private final int cacheBlockSizeKB;
    private final boolean directReads;
    private final boolean memoryOnly;

    private RocksDBConfig(TypedProperties properties) throws ConfigurationException {
        this.databaseDir = properties.get(DATABASE_DIR);
        this.writeBufferSizeMB = properties.getInt(WRITE_BUFFER_SIZE_MB);
        this.readCacheSizeMB = properties.getInt(READ_CACHE_SIZE_MB);
        this.cacheBlockSizeKB = properties.getInt(CACHE_BLOCK_SIZE_KB);
        this.directReads = properties.getBoolean(DIRECT_READS);
        this.memoryOnly = properties.getBoolean(MEM_ONLY);
    }

    public static ConfigBuilder<RocksDBConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, RocksDBConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getDatabaseDir() {
        return this.databaseDir;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getWriteBufferSizeMB() {
        return this.writeBufferSizeMB;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getReadCacheSizeMB() {
        return this.readCacheSizeMB;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCacheBlockSizeKB() {
        return this.cacheBlockSizeKB;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isDirectReads() {
        return this.directReads;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isMemoryOnly() {
        return this.memoryOnly;
    }
}

