/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.rocksdb;

import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.StatsLogger;

final class RocksDBMetrics {
    private static final StatsLogger STATS_LOGGER = MetricsProvider.createStatsLogger((String)"rocksdb");
    private static final OpStatsLogger INSERT_LATENCY = STATS_LOGGER.createStats("pravega.segmentstore.cache.insert_latency_ms", new String[0]);
    private static final OpStatsLogger INSERT_SIZE = STATS_LOGGER.createStats("pravega.segmentstore.cache.insert_size", new String[0]);
    private static final OpStatsLogger GET_LATENCY = STATS_LOGGER.createStats("pravega.segmentstore.cache.get_latency_ms", new String[0]);
    private static final OpStatsLogger GET_SIZE = STATS_LOGGER.createStats("pravega.segmentstore.cache.get_size", new String[0]);
    private static final OpStatsLogger DELETE_LATENCY = STATS_LOGGER.createStats("pravega.segmentstore.cache.delete_latency_ms", new String[0]);
    private static final DynamicLogger DYNAMIC_LOGGER = MetricsProvider.getDynamicLogger();

    RocksDBMetrics() {
    }

    static void insert(long elapsedMillis, long insertDataSize) {
        DYNAMIC_LOGGER.incCounterValue("pravega.segmentstore.cache.write_bytes", insertDataSize, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.segmentstore.cache.insert_count", 1L, new String[0]);
        INSERT_LATENCY.reportSuccessValue(elapsedMillis);
        INSERT_SIZE.reportSuccessValue(insertDataSize);
    }

    static void get(long elapsedMillis, long getDataSize) {
        DYNAMIC_LOGGER.incCounterValue("pravega.segmentstore.cache.read_bytes", getDataSize, new String[0]);
        DYNAMIC_LOGGER.incCounterValue("pravega.segmentstore.cache.get_count", 1L, new String[0]);
        GET_LATENCY.reportSuccessValue(elapsedMillis);
        GET_SIZE.reportSuccessValue(getDataSize);
    }

    public static void delete(long elapsedMillis) {
        DELETE_LATENCY.reportSuccessValue(elapsedMillis);
        DYNAMIC_LOGGER.incCounterValue("pravega.segmentstore.cache.delete_count", 1L, new String[0]);
    }
}

