/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin;

import com.google.common.annotations.Beta;
import io.pravega.client.ClientConfig;
import io.pravega.client.admin.StreamInfo;
import io.pravega.client.admin.impl.StreamManagerImpl;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.StreamCut;
import java.net.URI;
import java.util.Iterator;

public interface StreamManager
extends AutoCloseable {
    public static StreamManager create(URI controller) {
        return StreamManager.create(ClientConfig.builder().controllerURI(controller).build());
    }

    public static StreamManager create(ClientConfig clientConfig) {
        return new StreamManagerImpl(clientConfig);
    }

    public boolean createStream(String var1, String var2, StreamConfiguration var3);

    public boolean updateStream(String var1, String var2, StreamConfiguration var3);

    public boolean truncateStream(String var1, String var2, StreamCut var3);

    public boolean sealStream(String var1, String var2);

    public boolean deleteStream(String var1, String var2);

    public Iterator<String> listScopes();

    public boolean createScope(String var1);

    public boolean checkScopeExists(String var1);

    public Iterator<Stream> listStreams(String var1);

    public boolean checkStreamExists(String var1, String var2);

    public boolean deleteScope(String var1);

    @Beta
    public StreamInfo getStreamInfo(String var1, String var2);

    @Override
    public void close();
}

