/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.batch.impl;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.batch.SegmentIterator;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.client.segment.impl.NoSuchSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.TruncatedDataException;
import io.pravega.common.util.Retry;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SegmentIteratorImpl<T>
implements SegmentIterator<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentIteratorImpl.class);
    private final Segment segment;
    private final Serializer<T> deserializer;
    private final long startingOffset;
    private final long endingOffset;
    private final EventSegmentReader input;
    private final Retry.RetryWithBackoff backoffSchedule = Retry.withExpBackoff(1L, 10, 9, 30000L);

    public SegmentIteratorImpl(SegmentInputStreamFactory factory, Segment segment, Serializer<T> deserializer, long startingOffset, long endingOffset) {
        this.segment = segment;
        this.deserializer = deserializer;
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.input = factory.createEventReaderForSegment(segment);
        this.input.setOffset(startingOffset);
    }

    @Override
    public boolean hasNext() {
        return this.input.getOffset() < this.endingOffset;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ByteBuffer read = this.backoffSchedule.retryWhen(t -> t instanceof TimeoutException).run(() -> {
            try {
                ByteBuffer buffer = this.input.read();
                if (buffer == null) {
                    log.warn("Empty buffer while reading from Segment {} at offset {}", (Object)this.input.getSegmentId(), (Object)this.input.getOffset());
                    throw new TimeoutException(this.input.toString());
                }
                return buffer;
            }
            catch (NoSuchSegmentException | SegmentTruncatedException e) {
                throw new TruncatedDataException("Segment " + this.segment + " has been truncated.");
            }
        });
        return this.deserializer.deserialize(read);
    }

    @Override
    public long getOffset() {
        return this.input.getOffset();
    }

    @Override
    public void close() {
        this.input.close();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStartingOffset() {
        return this.startingOffset;
    }
}

