/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.byteStream.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ByteStreamClientFactory;
import io.pravega.client.byteStream.ByteStreamReader;
import io.pravega.client.byteStream.ByteStreamWriter;
import io.pravega.client.byteStream.impl.BufferedByteStreamWriterImpl;
import io.pravega.client.byteStream.impl.ByteStreamReaderImpl;
import io.pravega.client.byteStream.impl.ByteStreamWriterImpl;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentMetadataClientFactory;
import io.pravega.client.segment.impl.SegmentOutputStreamFactory;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.impl.StreamSegments;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public class ByteStreamClientImpl
implements ByteStreamClientFactory {
    @NonNull
    private final String scope;
    @NonNull
    private final Controller controller;
    @NonNull
    private final ConnectionPool connectionPool;
    @NonNull
    private final SegmentInputStreamFactory inputStreamFactory;
    @NonNull
    private final SegmentOutputStreamFactory outputStreamFactory;
    @NonNull
    private final SegmentMetadataClientFactory metaStreamFactory;

    @Override
    public ByteStreamReader createByteStreamReader(String streamName) {
        Map<Segment, Long> segments = Futures.getThrowingException(this.controller.getSegmentsAtTime(Stream.of(this.scope, streamName), 0L));
        Preconditions.checkState(segments.size() == 1, "ByteStreamReader supports single segment stream. Provided stream contains %s segments", segments.size());
        Segment segment = segments.keySet().iterator().next();
        return this.createByteStreamReaders(segment);
    }

    private ByteStreamReader createByteStreamReaders(Segment segment) {
        String delegationToken = Futures.getAndHandleExceptions(this.controller.getOrRefreshDelegationTokenFor(segment.getScope(), segment.getStream().getStreamName()), RuntimeException::new);
        DelegationTokenProvider tokenProvider = DelegationTokenProviderFactory.create(delegationToken, this.controller, segment);
        SegmentMetadataClient metaClient = this.metaStreamFactory.createSegmentMetadataClient(segment, tokenProvider);
        long startOffset = metaClient.getSegmentInfo().getStartingOffset();
        return new ByteStreamReaderImpl(this.inputStreamFactory.createInputStreamForSegment(segment, tokenProvider, startOffset), metaClient);
    }

    @Override
    public ByteStreamWriter createByteStreamWriter(String streamName) {
        StreamSegments segments = Futures.getThrowingException(this.controller.getCurrentSegments(this.scope, streamName));
        Preconditions.checkState(segments.getNumberOfSegments() > 0, "Stream is sealed");
        Preconditions.checkState(segments.getNumberOfSegments() == 1, "Stream is configured with more than one segment");
        Segment segment = segments.getSegments().iterator().next();
        EventWriterConfig config = EventWriterConfig.builder().build();
        DelegationTokenProvider tokenProvider = DelegationTokenProviderFactory.create(segments.getDelegationToken(), this.controller, segment);
        return new BufferedByteStreamWriterImpl(new ByteStreamWriterImpl(this.outputStreamFactory.createOutputStreamForSegment(segment, config, tokenProvider), this.metaStreamFactory.createSegmentMetadataClient(segment, tokenProvider)));
    }

    @Override
    public void close() {
        this.controller.close();
        this.connectionPool.close();
    }

    @ConstructorProperties(value={"scope", "controller", "connectionPool", "inputStreamFactory", "outputStreamFactory", "metaStreamFactory"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteStreamClientImpl(@NonNull String scope, @NonNull Controller controller, @NonNull ConnectionPool connectionPool, @NonNull SegmentInputStreamFactory inputStreamFactory, @NonNull SegmentOutputStreamFactory outputStreamFactory, @NonNull SegmentMetadataClientFactory metaStreamFactory) {
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (connectionPool == null) {
            throw new NullPointerException("connectionPool is marked non-null but is null");
        }
        if (inputStreamFactory == null) {
            throw new NullPointerException("inputStreamFactory is marked non-null but is null");
        }
        if (outputStreamFactory == null) {
            throw new NullPointerException("outputStreamFactory is marked non-null but is null");
        }
        if (metaStreamFactory == null) {
            throw new NullPointerException("metaStreamFactory is marked non-null but is null");
        }
        this.scope = scope;
        this.controller = controller;
        this.connectionPool = connectionPool;
        this.inputStreamFactory = inputStreamFactory;
        this.outputStreamFactory = outputStreamFactory;
        this.metaStreamFactory = metaStreamFactory;
    }
}

