/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.control.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.impl.SegmentWithRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import lombok.Generated;

public abstract class SegmentCollection {
    protected final NavigableMap<Double, SegmentWithRange> segments;
    private final String delegationToken;

    public SegmentCollection(NavigableMap<Double, SegmentWithRange> segments, String delegationToken) {
        this.segments = Collections.unmodifiableNavigableMap(segments);
        this.delegationToken = delegationToken;
        this.verifySegments();
    }

    private void verifySegments() {
        if (!this.segments.isEmpty()) {
            Preconditions.checkArgument((Double)this.segments.firstKey() > 0.0, "Nonsense value for segment.");
            Preconditions.checkArgument((Double)this.segments.lastKey() >= 1.0, "Last segment missing.");
            Preconditions.checkArgument((Double)this.segments.lastKey() < 1.00001, "Segments should only go up to 1.0");
        }
    }

    protected abstract double hashToRange(String var1);

    public Segment getSegmentForKey(String key) {
        return this.getSegmentForKey(this.hashToRange(key));
    }

    public Segment getSegmentForKey(double key) {
        Preconditions.checkArgument(key >= 0.0);
        Preconditions.checkArgument(key <= 1.0);
        return this.segments.ceilingEntry(key).getValue().getSegment();
    }

    public Collection<Segment> getSegments() {
        ArrayList<Segment> result = new ArrayList<Segment>(this.segments.size());
        for (SegmentWithRange seg : this.segments.values()) {
            result.add(seg.getSegment());
        }
        return result;
    }

    public String toString() {
        return "StreamSegments:" + this.segments.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentCollection)) {
            return false;
        }
        SegmentCollection other = (SegmentCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<Segment> this$segments = this.getSegments();
        Collection<Segment> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
            return false;
        }
        String this$delegationToken = this.getDelegationToken();
        String other$delegationToken = other.getDelegationToken();
        return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentCollection;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<Segment> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        String $delegationToken = this.getDelegationToken();
        result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDelegationToken() {
        return this.delegationToken;
    }
}

