/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.security.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationToken;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.security.JwtUtils;
import io.pravega.common.util.ConfigurationOptionsExtractor;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenProviderImpl
implements DelegationTokenProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtTokenProviderImpl.class);
    @VisibleForTesting
    static final int DEFAULT_REFRESH_THRESHOLD_SECONDS = 5;
    private static final String REFRESH_THRESHOLD_SYSTEM_PROPERTY = "pravega.client.auth.token-refresh.threshold";
    private static final String REFRESH_THRESHOLD_ENV_VARIABLE = "pravega_client_auth_token-refresh.threshold";
    @VisibleForTesting
    private final int refreshThresholdInSeconds;
    private final Controller controllerClient;
    private final String scopeName;
    private final String streamName;
    private final AtomicReference<DelegationToken> delegationToken = new AtomicReference();
    private final AtomicBoolean tokenExpirySignal = new AtomicBoolean(false);
    @VisibleForTesting
    private final AtomicReference<CompletableFuture<Void>> tokenRefreshFuture = new AtomicReference();

    JwtTokenProviderImpl(Controller controllerClient, String scopeName, String streamName) {
        this(controllerClient, scopeName, streamName, ConfigurationOptionsExtractor.extractInt(REFRESH_THRESHOLD_SYSTEM_PROPERTY, REFRESH_THRESHOLD_ENV_VARIABLE, 5));
    }

    private JwtTokenProviderImpl(Controller controllerClient, String scopeName, String streamName, int refreshThresholdInSeconds) {
        Exceptions.checkNotNullOrEmpty(scopeName, "scopeName");
        Preconditions.checkNotNull(controllerClient, "controllerClient is null");
        Exceptions.checkNotNullOrEmpty(streamName, "streamName");
        this.scopeName = scopeName;
        this.streamName = streamName;
        this.controllerClient = controllerClient;
        this.refreshThresholdInSeconds = refreshThresholdInSeconds;
    }

    JwtTokenProviderImpl(String token, Controller controllerClient, String scopeName, String streamName) {
        this(token, controllerClient, scopeName, streamName, ConfigurationOptionsExtractor.extractInt(REFRESH_THRESHOLD_SYSTEM_PROPERTY, REFRESH_THRESHOLD_ENV_VARIABLE, 5));
    }

    JwtTokenProviderImpl(String token, Controller controllerClient, String scopeName, String streamName, int refreshThresholdInSeconds) {
        Exceptions.checkNotNullOrEmpty(token, "delegationToken");
        Exceptions.checkNotNullOrEmpty(scopeName, "scopeName");
        Preconditions.checkNotNull(controllerClient, "controllerClient is null");
        Exceptions.checkNotNullOrEmpty(streamName, "streamName");
        Long expTime = JwtUtils.extractExpirationTime(token);
        this.delegationToken.set(new DelegationToken(token, expTime));
        this.scopeName = scopeName;
        this.streamName = streamName;
        this.controllerClient = controllerClient;
        this.refreshThresholdInSeconds = refreshThresholdInSeconds;
    }

    @Override
    public CompletableFuture<String> retrieveToken() {
        CompletableFuture<String> result;
        DelegationToken currentToken = this.delegationToken.get();
        if (currentToken == null) {
            result = this.refreshToken();
        } else if (currentToken.getExpiryTime() == null) {
            result = CompletableFuture.completedFuture(currentToken.getValue());
        } else if (this.tokenExpirySignal.get()) {
            log.debug("Token was signaled as expired for scope/stream {}/{}", (Object)this.scopeName, (Object)this.streamName);
            result = this.refreshToken();
            this.tokenExpirySignal.compareAndSet(true, false);
        } else if (this.isTokenNearingExpiry(currentToken)) {
            log.debug("Token is nearing expiry for scope/stream {}/{}", (Object)this.scopeName, (Object)this.streamName);
            result = this.refreshToken();
        } else {
            result = CompletableFuture.completedFuture(currentToken.getValue());
        }
        return result;
    }

    @Override
    public boolean populateToken(String token) {
        DelegationToken currentToken = this.delegationToken.get();
        if (token == null || currentToken != null && currentToken.getValue().equals("")) {
            return false;
        }
        return this.delegationToken.compareAndSet(currentToken, new DelegationToken(token, JwtUtils.extractExpirationTime(token)));
    }

    @Override
    public void signalTokenExpired() {
        this.tokenExpirySignal.compareAndSet(false, true);
    }

    private boolean isTokenNearingExpiry(DelegationToken token) {
        Long currentTokenExpirationTime = token.getExpiryTime();
        return currentTokenExpirationTime != null && this.isWithinRefreshThreshold(currentTokenExpirationTime);
    }

    private boolean isWithinRefreshThreshold(Long expirationTime) {
        assert (expirationTime != null);
        return this.isWithinRefreshThreshold(Instant.now(), Instant.ofEpochSecond(expirationTime));
    }

    @VisibleForTesting
    boolean isWithinRefreshThreshold(Instant currentInstant, Instant expiration) {
        return currentInstant.plusSeconds(this.refreshThresholdInSeconds).getEpochSecond() >= expiration.getEpochSecond();
    }

    @VisibleForTesting
    CompletableFuture<String> refreshToken() {
        long traceEnterId = LoggerHelpers.traceEnter(log, "refreshToken", this.scopeName, this.streamName);
        CompletableFuture<Void> currentRefreshFuture = this.tokenRefreshFuture.get();
        if (currentRefreshFuture == null) {
            log.debug("Initiating token refresh for scope {} and stream {}", (Object)this.scopeName, (Object)this.streamName);
            currentRefreshFuture = this.recreateToken();
            this.tokenRefreshFuture.compareAndSet(null, currentRefreshFuture);
        } else {
            log.debug("Token is already under refresh for scope {} and stream {}", (Object)this.scopeName, (Object)this.streamName);
        }
        CompletableFuture<Void> handleToCurrentRefreshFuture = currentRefreshFuture;
        return currentRefreshFuture.handle((v, ex) -> {
            this.tokenRefreshFuture.compareAndSet(handleToCurrentRefreshFuture, null);
            LoggerHelpers.traceLeave(log, "refreshToken", traceEnterId, this.scopeName, this.streamName);
            if (ex != null) {
                log.warn("Encountered an exception in when refreshing token for scope {} and stream {}", this.scopeName, this.streamName, Exceptions.unwrap(ex));
                throw ex instanceof CompletionException ? (CompletionException)ex : new CompletionException((Throwable)ex);
            }
            return this.delegationToken.get().getValue();
        });
    }

    private CompletableFuture<Void> recreateToken() {
        return this.controllerClient.getOrRefreshDelegationTokenFor(this.scopeName, this.streamName).thenAccept(token -> this.delegationToken.set(new DelegationToken((String)token, JwtUtils.extractExpirationTime(token))));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    int getRefreshThresholdInSeconds() {
        return this.refreshThresholdInSeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    AtomicReference<CompletableFuture<Void>> getTokenRefreshFuture() {
        return this.tokenRefreshFuture;
    }
}

