/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.Generated;

public class EventWriterConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int initialBackoffMillis;
    private final int maxBackoffMillis;
    private final int retryAttempts;
    private final int backoffMultiple;
    private final boolean enableConnectionPooling;
    private final long transactionTimeoutTime;
    private final boolean automaticallyNoteTime;

    @ConstructorProperties(value={"initialBackoffMillis", "maxBackoffMillis", "retryAttempts", "backoffMultiple", "enableConnectionPooling", "transactionTimeoutTime", "automaticallyNoteTime"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    EventWriterConfig(int initialBackoffMillis, int maxBackoffMillis, int retryAttempts, int backoffMultiple, boolean enableConnectionPooling, long transactionTimeoutTime, boolean automaticallyNoteTime) {
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.retryAttempts = retryAttempts;
        this.backoffMultiple = backoffMultiple;
        this.enableConnectionPooling = enableConnectionPooling;
        this.transactionTimeoutTime = transactionTimeoutTime;
        this.automaticallyNoteTime = automaticallyNoteTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static EventWriterConfigBuilder builder() {
        return new EventWriterConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBackoffMultiple() {
        return this.backoffMultiple;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableConnectionPooling() {
        return this.enableConnectionPooling;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTransactionTimeoutTime() {
        return this.transactionTimeoutTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAutomaticallyNoteTime() {
        return this.automaticallyNoteTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventWriterConfig)) {
            return false;
        }
        EventWriterConfig other = (EventWriterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialBackoffMillis() != other.getInitialBackoffMillis()) {
            return false;
        }
        if (this.getMaxBackoffMillis() != other.getMaxBackoffMillis()) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        if (this.getBackoffMultiple() != other.getBackoffMultiple()) {
            return false;
        }
        if (this.isEnableConnectionPooling() != other.isEnableConnectionPooling()) {
            return false;
        }
        if (this.getTransactionTimeoutTime() != other.getTransactionTimeoutTime()) {
            return false;
        }
        return this.isAutomaticallyNoteTime() == other.isAutomaticallyNoteTime();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventWriterConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialBackoffMillis();
        result = result * 59 + this.getMaxBackoffMillis();
        result = result * 59 + this.getRetryAttempts();
        result = result * 59 + this.getBackoffMultiple();
        result = result * 59 + (this.isEnableConnectionPooling() ? 79 : 97);
        long $transactionTimeoutTime = this.getTransactionTimeoutTime();
        result = result * 59 + (int)($transactionTimeoutTime >>> 32 ^ $transactionTimeoutTime);
        result = result * 59 + (this.isAutomaticallyNoteTime() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EventWriterConfig(initialBackoffMillis=" + this.getInitialBackoffMillis() + ", maxBackoffMillis=" + this.getMaxBackoffMillis() + ", retryAttempts=" + this.getRetryAttempts() + ", backoffMultiple=" + this.getBackoffMultiple() + ", enableConnectionPooling=" + this.isEnableConnectionPooling() + ", transactionTimeoutTime=" + this.getTransactionTimeoutTime() + ", automaticallyNoteTime=" + this.isAutomaticallyNoteTime() + ")";
    }

    public static final class EventWriterConfigBuilder {
        private static final long MIN_TRANSACTION_TIMEOUT_TIME_MILLIS = 10000L;
        private int initialBackoffMillis = 1;
        private int maxBackoffMillis = 20000;
        private int retryAttempts = 10;
        private int backoffMultiple = 10;
        private long transactionTimeoutTime = 89999L;
        private boolean automaticallyNoteTime = false;
        private boolean enableConnectionPooling = false;

        public EventWriterConfig build() {
            Preconditions.checkArgument(this.transactionTimeoutTime >= 10000L, "Transaction time must be at least 10 seconds.");
            Preconditions.checkArgument(this.initialBackoffMillis >= 0, "Backoff times must be positive numbers");
            Preconditions.checkArgument(this.backoffMultiple >= 0, "Backoff multiple must be positive numbers");
            Preconditions.checkArgument(this.maxBackoffMillis >= 0, "Backoff times must be positive numbers");
            Preconditions.checkArgument(this.retryAttempts >= 0, "Retry attempts must be a positive number");
            return new EventWriterConfig(this.initialBackoffMillis, this.maxBackoffMillis, this.retryAttempts, this.backoffMultiple, this.enableConnectionPooling, this.transactionTimeoutTime, this.automaticallyNoteTime);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        EventWriterConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder initialBackoffMillis(int initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder maxBackoffMillis(int maxBackoffMillis) {
            this.maxBackoffMillis = maxBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder retryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder backoffMultiple(int backoffMultiple) {
            this.backoffMultiple = backoffMultiple;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder enableConnectionPooling(boolean enableConnectionPooling) {
            this.enableConnectionPooling = enableConnectionPooling;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder transactionTimeoutTime(long transactionTimeoutTime) {
            this.transactionTimeoutTime = transactionTimeoutTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder automaticallyNoteTime(boolean automaticallyNoteTime) {
            this.automaticallyNoteTime = automaticallyNoteTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "EventWriterConfig.EventWriterConfigBuilder(initialBackoffMillis=" + this.initialBackoffMillis + ", maxBackoffMillis=" + this.maxBackoffMillis + ", retryAttempts=" + this.retryAttempts + ", backoffMultiple=" + this.backoffMultiple + ", enableConnectionPooling=" + this.enableConnectionPooling + ", transactionTimeoutTime=" + this.transactionTimeoutTime + ", automaticallyNoteTime=" + this.automaticallyNoteTime + ")";
        }
    }
}

