/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Duration;
import lombok.Generated;

public class RetentionPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RetentionType retentionType;
    private final long retentionParam;

    public static RetentionPolicy byTime(Duration duration) {
        return new RetentionPolicy(RetentionType.TIME, duration.toMillis());
    }

    public static RetentionPolicy bySizeBytes(long size) {
        return new RetentionPolicy(RetentionType.SIZE, size);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static RetentionPolicyBuilder builder() {
        return new RetentionPolicyBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RetentionType getRetentionType() {
        return this.retentionType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRetentionParam() {
        return this.retentionParam;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetentionPolicy)) {
            return false;
        }
        RetentionPolicy other = (RetentionPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RetentionType this$retentionType = this.getRetentionType();
        RetentionType other$retentionType = other.getRetentionType();
        if (this$retentionType == null ? other$retentionType != null : !((Object)((Object)this$retentionType)).equals((Object)other$retentionType)) {
            return false;
        }
        return this.getRetentionParam() == other.getRetentionParam();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RetentionPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RetentionType $retentionType = this.getRetentionType();
        result = result * 59 + ($retentionType == null ? 43 : ((Object)((Object)$retentionType)).hashCode());
        long $retentionParam = this.getRetentionParam();
        result = result * 59 + (int)($retentionParam >>> 32 ^ $retentionParam);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "RetentionPolicy(retentionType=" + (Object)((Object)this.getRetentionType()) + ", retentionParam=" + this.getRetentionParam() + ")";
    }

    @ConstructorProperties(value={"retentionType", "retentionParam"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private RetentionPolicy(RetentionType retentionType, long retentionParam) {
        this.retentionType = retentionType;
        this.retentionParam = retentionParam;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class RetentionPolicyBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private RetentionType retentionType;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long retentionParam;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        RetentionPolicyBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RetentionPolicyBuilder retentionType(RetentionType retentionType) {
            this.retentionType = retentionType;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RetentionPolicyBuilder retentionParam(long retentionParam) {
            this.retentionParam = retentionParam;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RetentionPolicy build() {
            return new RetentionPolicy(this.retentionType, this.retentionParam);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "RetentionPolicy.RetentionPolicyBuilder(retentionType=" + (Object)((Object)this.retentionType) + ", retentionParam=" + this.retentionParam + ")";
        }
    }

    public static enum RetentionType {
        TIME,
        SIZE;

    }
}

