/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.Generated;

public class ScalingPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ScaleType scaleType;
    private final int targetRate;
    private final int scaleFactor;
    private final int minNumSegments;

    public static ScalingPolicy fixed(int numSegments) {
        Preconditions.checkArgument(numSegments > 0, "Number of segments should be > 0.");
        return new ScalingPolicy(ScaleType.FIXED_NUM_SEGMENTS, 0, 0, numSegments);
    }

    public static ScalingPolicy byEventRate(int targetRate, int scaleFactor, int minNumSegments) {
        Preconditions.checkArgument(targetRate > 0, "Target rate should be > 0.");
        Preconditions.checkArgument(scaleFactor > 0, "Scale factor should be > 0. Otherwise use fixed scaling policy.");
        Preconditions.checkArgument(minNumSegments > 0, "Minimum number of segments should be > 0.");
        return new ScalingPolicy(ScaleType.BY_RATE_IN_EVENTS_PER_SEC, targetRate, scaleFactor, minNumSegments);
    }

    public static ScalingPolicy byDataRate(int targetKBps, int scaleFactor, int minNumSegments) {
        Preconditions.checkArgument(targetKBps > 0, "KBps should be > 0.");
        Preconditions.checkArgument(scaleFactor > 0, "Scale factor should be > 0. Otherwise use fixed scaling policy.");
        Preconditions.checkArgument(minNumSegments > 0, "Minimum number of segments should be > 0.");
        return new ScalingPolicy(ScaleType.BY_RATE_IN_KBYTES_PER_SEC, targetKBps, scaleFactor, minNumSegments);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ScalingPolicyBuilder builder() {
        return new ScalingPolicyBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScaleType getScaleType() {
        return this.scaleType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getTargetRate() {
        return this.targetRate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getScaleFactor() {
        return this.scaleFactor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMinNumSegments() {
        return this.minNumSegments;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScaleType this$scaleType = this.getScaleType();
        ScaleType other$scaleType = other.getScaleType();
        if (this$scaleType == null ? other$scaleType != null : !((Object)((Object)this$scaleType)).equals((Object)other$scaleType)) {
            return false;
        }
        if (this.getTargetRate() != other.getTargetRate()) {
            return false;
        }
        if (this.getScaleFactor() != other.getScaleFactor()) {
            return false;
        }
        return this.getMinNumSegments() == other.getMinNumSegments();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScalingPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScaleType $scaleType = this.getScaleType();
        result = result * 59 + ($scaleType == null ? 43 : ((Object)((Object)$scaleType)).hashCode());
        result = result * 59 + this.getTargetRate();
        result = result * 59 + this.getScaleFactor();
        result = result * 59 + this.getMinNumSegments();
        return result;
    }

    @ConstructorProperties(value={"scaleType", "targetRate", "scaleFactor", "minNumSegments"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ScalingPolicy(ScaleType scaleType, int targetRate, int scaleFactor, int minNumSegments) {
        this.scaleType = scaleType;
        this.targetRate = targetRate;
        this.scaleFactor = scaleFactor;
        this.minNumSegments = minNumSegments;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ScalingPolicy(scaleType=" + (Object)((Object)this.getScaleType()) + ", targetRate=" + this.getTargetRate() + ", scaleFactor=" + this.getScaleFactor() + ", minNumSegments=" + this.getMinNumSegments() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ScalingPolicyBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ScaleType scaleType;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int targetRate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int scaleFactor;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int minNumSegments;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ScalingPolicyBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScalingPolicyBuilder scaleType(ScaleType scaleType) {
            this.scaleType = scaleType;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScalingPolicyBuilder targetRate(int targetRate) {
            this.targetRate = targetRate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScalingPolicyBuilder scaleFactor(int scaleFactor) {
            this.scaleFactor = scaleFactor;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScalingPolicyBuilder minNumSegments(int minNumSegments) {
            this.minNumSegments = minNumSegments;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScalingPolicy build() {
            return new ScalingPolicy(this.scaleType, this.targetRate, this.scaleFactor, this.minNumSegments);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ScalingPolicy.ScalingPolicyBuilder(scaleType=" + (Object)((Object)this.scaleType) + ", targetRate=" + this.targetRate + ", scaleFactor=" + this.scaleFactor + ", minNumSegments=" + this.minNumSegments + ")";
        }
    }

    public static enum ScaleType {
        FIXED_NUM_SEGMENTS(io.pravega.shared.segment.ScaleType.NoScaling.getValue()),
        BY_RATE_IN_KBYTES_PER_SEC(io.pravega.shared.segment.ScaleType.NoScaling.getValue()),
        BY_RATE_IN_EVENTS_PER_SEC(io.pravega.shared.segment.ScaleType.NoScaling.getValue());

        private final byte value;

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ScaleType(byte value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte getValue() {
            return this.value;
        }
    }
}

