/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ByteArraySegment;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CheckpointState {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckpointState.class);
    private static final CheckpointStateSerializer SERIALIZER = new CheckpointStateSerializer();
    private final List<String> checkpoints;
    private final Map<String, List<String>> uncheckpointedHosts;
    private Map<String, List<String>> checkpointIndex;
    private final Map<String, Map<Segment, Long>> checkpointPositions;
    private Map<Segment, Long> lastCheckpointPosition;

    public CheckpointState() {
        this(new ArrayList<String>(), new HashMap<String, List<String>>(), new HashMap<String, Map<Segment, Long>>(), null);
    }

    private CheckpointState(List<String> checkpoints, Map<String, List<String>> uncheckpointedHosts, Map<String, Map<Segment, Long>> checkpointPositions, Map<Segment, Long> lastCheckpointPosition) {
        Preconditions.checkNotNull(checkpoints);
        Preconditions.checkNotNull(uncheckpointedHosts);
        Preconditions.checkNotNull(checkpointPositions);
        this.checkpoints = checkpoints;
        this.uncheckpointedHosts = uncheckpointedHosts;
        this.checkpointPositions = checkpointPositions;
        this.lastCheckpointPosition = lastCheckpointPosition;
        this.recomputeCheckpointIndex();
    }

    void beginNewCheckpoint(String checkpointId, Set<String> currentReaders, Map<Segment, Long> knownPositions) {
        if (!this.checkpointPositions.containsKey(checkpointId)) {
            if (!currentReaders.isEmpty()) {
                this.uncheckpointedHosts.put(checkpointId, new ArrayList<String>(currentReaders));
            }
            this.checkpointPositions.put(checkpointId, new HashMap<Segment, Long>(knownPositions));
            this.checkpoints.add(checkpointId);
        }
        this.recomputeCheckpointIndex();
    }

    String getCheckpointForReader(String readerName) {
        List<String> checkpointsForReader = this.getCheckpointsForReader(readerName);
        return checkpointsForReader.isEmpty() ? null : checkpointsForReader.get(0);
    }

    private List<String> getCheckpointsForReader(String readerName) {
        return this.checkpointIndex.getOrDefault(readerName, Collections.emptyList());
    }

    private void recomputeCheckpointIndex() {
        this.checkpointIndex = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.uncheckpointedHosts.entrySet()) {
            String checkpointId = entry.getKey();
            for (String host : entry.getValue()) {
                List checkpointsForHost = this.checkpointIndex.computeIfAbsent(host, k -> new ArrayList());
                checkpointsForHost.add(checkpointId);
            }
        }
    }

    void removeReader(String readerName, Map<Segment, Long> position) {
        List<String> toCheckpoint = this.checkpointIndex.remove(readerName);
        if (toCheckpoint != null) {
            for (String checkpointId : toCheckpoint) {
                this.readerCheckpointed(checkpointId, readerName, position);
            }
        }
    }

    void readerCheckpointed(String checkpointId, String readerName, Map<Segment, Long> position) {
        log.debug("Reader : {} completed checkpointing for Checkpoint : {}", (Object)readerName, (Object)checkpointId);
        List<String> readers = this.uncheckpointedHosts.get(checkpointId);
        if (readers != null) {
            boolean removed = readers.remove(readerName);
            Preconditions.checkState(removed, "Reader already checkpointed.");
            List<String> cps = this.checkpointIndex.get(readerName);
            if (cps != null) {
                cps.remove(checkpointId);
            }
            Map<Segment, Long> positions = this.checkpointPositions.get(checkpointId);
            positions.putAll(position);
            if (readers.isEmpty()) {
                this.uncheckpointedHosts.remove(checkpointId);
                this.lastCheckpointPosition = this.checkpointPositions.get(checkpointId);
            }
        }
    }

    boolean isCheckpointComplete(String checkpointId) {
        return !this.uncheckpointedHosts.containsKey(checkpointId);
    }

    boolean isCheckpointSilent(String checkpointId) {
        return checkpointId.contains("_SILENT_");
    }

    Map<Segment, Long> getPositionsForCompletedCheckpoint(String checkpointId) {
        if (this.uncheckpointedHosts.containsKey(checkpointId)) {
            return null;
        }
        return this.checkpointPositions.get(checkpointId);
    }

    Optional<Map<Segment, Long>> getPositionsForLatestCompletedCheckpoint() {
        return Optional.ofNullable(this.lastCheckpointPosition);
    }

    boolean hasOngoingCheckpoint() {
        return !this.uncheckpointedHosts.isEmpty();
    }

    List<String> getOutstandingCheckpoints() {
        return this.checkpoints.stream().filter(checkpoint -> !this.isCheckpointSilent((String)checkpoint) && !this.isCheckpointComplete((String)checkpoint)).collect(Collectors.toList());
    }

    void clearCheckpointsBefore(String checkpointId) {
        if (this.checkpointPositions.containsKey(checkpointId)) {
            String cp;
            Iterator<String> iterator = this.checkpoints.iterator();
            while (iterator.hasNext() && !(cp = iterator.next()).equals(checkpointId)) {
                this.uncheckpointedHosts.remove(cp);
                this.checkpointPositions.remove(cp);
                iterator.remove();
            }
            this.recomputeCheckpointIndex();
        }
    }

    CheckpointState copy() {
        ArrayList<String> cps = new ArrayList<String>(this.checkpoints);
        HashMap<String, List<String>> ucph = new HashMap<String, List<String>>(this.uncheckpointedHosts.size());
        this.uncheckpointedHosts.forEach((cp, hosts) -> {
            List cfr_ignored_0 = ucph.put((String)cp, new ArrayList(hosts));
        });
        HashMap<String, Map<Segment, Long>> cpps = new HashMap<String, Map<Segment, Long>>();
        this.checkpointPositions.forEach((cp, pos) -> {
            Map cfr_ignored_0 = cpps.put((String)cp, new HashMap(pos));
        });
        HashMap<Segment, Long> lcp = this.lastCheckpointPosition == null ? null : new HashMap<Segment, Long>(this.lastCheckpointPosition);
        return new CheckpointState(cps, ucph, cpps, lcp);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CheckpointState { ongoingCheckpoints: ");
        sb.append(this.checkpoints.toString());
        sb.append(",  readersBlockingEachCheckpoint: ");
        sb.append(this.uncheckpointedHosts.toString());
        sb.append(" }");
        return sb.toString();
    }

    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static CheckpointState fromBytes(ByteBuffer buff) {
        return (CheckpointState)SERIALIZER.deserialize(new ByteArraySegment(buff));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static CheckpointStateBuilder builder() {
        return new CheckpointStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointState)) {
            return false;
        }
        CheckpointState other = (CheckpointState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$checkpoints = this.checkpoints;
        List<String> other$checkpoints = other.checkpoints;
        if (this$checkpoints == null ? other$checkpoints != null : !((Object)this$checkpoints).equals(other$checkpoints)) {
            return false;
        }
        Map<String, List<String>> this$uncheckpointedHosts = this.uncheckpointedHosts;
        Map<String, List<String>> other$uncheckpointedHosts = other.uncheckpointedHosts;
        if (this$uncheckpointedHosts == null ? other$uncheckpointedHosts != null : !((Object)this$uncheckpointedHosts).equals(other$uncheckpointedHosts)) {
            return false;
        }
        Map<String, List<String>> this$checkpointIndex = this.checkpointIndex;
        Map<String, List<String>> other$checkpointIndex = other.checkpointIndex;
        if (this$checkpointIndex == null ? other$checkpointIndex != null : !((Object)this$checkpointIndex).equals(other$checkpointIndex)) {
            return false;
        }
        Map<String, Map<Segment, Long>> this$checkpointPositions = this.checkpointPositions;
        Map<String, Map<Segment, Long>> other$checkpointPositions = other.checkpointPositions;
        if (this$checkpointPositions == null ? other$checkpointPositions != null : !((Object)this$checkpointPositions).equals(other$checkpointPositions)) {
            return false;
        }
        Map<Segment, Long> this$lastCheckpointPosition = this.lastCheckpointPosition;
        Map<Segment, Long> other$lastCheckpointPosition = other.lastCheckpointPosition;
        return !(this$lastCheckpointPosition == null ? other$lastCheckpointPosition != null : !((Object)this$lastCheckpointPosition).equals(other$lastCheckpointPosition));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CheckpointState;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $checkpoints = this.checkpoints;
        result = result * 59 + ($checkpoints == null ? 43 : ((Object)$checkpoints).hashCode());
        Map<String, List<String>> $uncheckpointedHosts = this.uncheckpointedHosts;
        result = result * 59 + ($uncheckpointedHosts == null ? 43 : ((Object)$uncheckpointedHosts).hashCode());
        Map<String, List<String>> $checkpointIndex = this.checkpointIndex;
        result = result * 59 + ($checkpointIndex == null ? 43 : ((Object)$checkpointIndex).hashCode());
        Map<String, Map<Segment, Long>> $checkpointPositions = this.checkpointPositions;
        result = result * 59 + ($checkpointPositions == null ? 43 : ((Object)$checkpointPositions).hashCode());
        Map<Segment, Long> $lastCheckpointPosition = this.lastCheckpointPosition;
        result = result * 59 + ($lastCheckpointPosition == null ? 43 : ((Object)$lastCheckpointPosition).hashCode());
        return result;
    }

    private static class CheckpointStateSerializer
    extends VersionedSerializer.WithBuilder<CheckpointState, CheckpointStateBuilder> {
        private CheckpointStateSerializer() {
        }

        @Override
        protected CheckpointStateBuilder newBuilder() {
            return CheckpointState.builder();
        }

        @Override
        protected byte getWriteVersion() {
            return 0;
        }

        @Override
        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput input, CheckpointStateBuilder builder) throws IOException {
            RevisionDataInput.ElementDeserializer<String> stringDeserializer = DataInput::readUTF;
            RevisionDataInput.ElementDeserializer<Long> longDeserializer = DataInput::readLong;
            RevisionDataInput.ElementDeserializer<Segment> segmentDeserializer = in -> Segment.fromScopedName(in.readUTF());
            builder.checkpoints(input.readCollection(stringDeserializer, ArrayList::new));
            builder.uncheckpointedHosts(input.readMap(stringDeserializer, in -> in.readCollection(stringDeserializer, ArrayList::new)));
            builder.checkpointPositions(input.readMap(stringDeserializer, in -> in.readMap(segmentDeserializer, longDeserializer)));
            builder.lastCheckpointPosition(input.readMap(segmentDeserializer, longDeserializer));
        }

        private void write00(CheckpointState object, RevisionDataOutput output) throws IOException {
            RevisionDataOutput.ElementSerializer<String> stringSerializer = DataOutput::writeUTF;
            RevisionDataOutput.ElementSerializer<Long> longSerializer = DataOutput::writeLong;
            RevisionDataOutput.ElementSerializer<Segment> segmentSerializer = (out, segment) -> out.writeUTF(segment.getScopedName());
            output.writeCollection(object.checkpoints, stringSerializer);
            output.writeMap(object.uncheckpointedHosts, stringSerializer, (out, hosts) -> out.writeCollection(hosts, stringSerializer));
            output.writeMap(object.checkpointPositions, stringSerializer, (out, map) -> out.writeMap(map, segmentSerializer, longSerializer));
            output.writeMap(object.lastCheckpointPosition, segmentSerializer, longSerializer);
        }
    }

    @VisibleForTesting
    static class CheckpointStateBuilder
    implements ObjectBuilder<CheckpointState> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<String> checkpoints;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, List<String>> uncheckpointedHosts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, Map<Segment, Long>> checkpointPositions;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<Segment, Long> lastCheckpointPosition;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        CheckpointStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckpointStateBuilder checkpoints(List<String> checkpoints) {
            this.checkpoints = checkpoints;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckpointStateBuilder uncheckpointedHosts(Map<String, List<String>> uncheckpointedHosts) {
            this.uncheckpointedHosts = uncheckpointedHosts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckpointStateBuilder checkpointPositions(Map<String, Map<Segment, Long>> checkpointPositions) {
            this.checkpointPositions = checkpointPositions;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckpointStateBuilder lastCheckpointPosition(Map<Segment, Long> lastCheckpointPosition) {
            this.lastCheckpointPosition = lastCheckpointPosition;
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CheckpointState build() {
            return new CheckpointState(this.checkpoints, this.uncheckpointedHosts, this.checkpointPositions, this.lastCheckpointPosition);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CheckpointState.CheckpointStateBuilder(checkpoints=" + this.checkpoints + ", uncheckpointedHosts=" + this.uncheckpointedHosts + ", checkpointPositions=" + this.checkpointPositions + ", lastCheckpointPosition=" + this.lastCheckpointPosition + ")";
        }
    }
}

