/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.shared.protocol.netty.WireCommands;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class PendingEvent {
    public static final int MAX_WRITE_SIZE = 0x800008;
    private final String routingKey;
    private final ByteBuf data;
    private final CompletableFuture<Void> ackFuture;

    private PendingEvent(String routingKey, ByteBuf data, CompletableFuture<Void> ackFuture) {
        Preconditions.checkNotNull(data);
        Preconditions.checkArgument(data.readableBytes() <= 0x800008, "Write size too large: %s", data.readableBytes());
        this.routingKey = routingKey;
        this.data = data;
        this.ackFuture = ackFuture;
    }

    public static PendingEvent withHeader(String routingKey, ByteBuffer data, CompletableFuture<Void> ackFuture) {
        ByteBuf eventBuf = new WireCommands.Event(Unpooled.wrappedBuffer(data)).getAsByteBuf();
        return new PendingEvent(routingKey, eventBuf, ackFuture);
    }

    public static PendingEvent withoutHeader(String routingKey, ByteBuffer data, CompletableFuture<Void> ackFuture) {
        return new PendingEvent(routingKey, Unpooled.wrappedBuffer(data), ackFuture);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRoutingKey() {
        return this.routingKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuf getData() {
        return this.data;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CompletableFuture<Void> getAckFuture() {
        return this.ackFuture;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PendingEvent)) {
            return false;
        }
        PendingEvent other = (PendingEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        ByteBuf this$data = this.getData();
        ByteBuf other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        CompletableFuture<Void> this$ackFuture = this.getAckFuture();
        CompletableFuture<Void> other$ackFuture = other.getAckFuture();
        return !(this$ackFuture == null ? other$ackFuture != null : !this$ackFuture.equals(other$ackFuture));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PendingEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        ByteBuf $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        CompletableFuture<Void> $ackFuture = this.getAckFuture();
        result = result * 59 + ($ackFuture == null ? 43 : $ackFuture.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "PendingEvent(routingKey=" + this.getRoutingKey() + ", data=" + this.getData() + ", ackFuture=" + this.getAckFuture() + ")";
    }
}

