/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.control.impl.SegmentCollection;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.StreamSegmentsWithPredecessors;
import io.pravega.common.hash.HashHelper;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSegments
extends SegmentCollection {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamSegments.class);
    private static final HashHelper HASHER = HashHelper.seededWith("EventRouter");

    public StreamSegments(NavigableMap<Double, SegmentWithRange> segments, String delegationToken) {
        super(segments, delegationToken);
    }

    @Override
    protected double hashToRange(String key) {
        return HASHER.hashToRange(key);
    }

    public int getNumberOfSegments() {
        return this.segments.size();
    }

    public StreamSegments withReplacementRange(Segment segment, StreamSegmentsWithPredecessors replacementRanges) {
        SegmentWithRange replacedSegment = this.findReplacedSegment(segment);
        this.verifyReplacementRange(replacedSegment, replacementRanges);
        TreeMap<Double, SegmentWithRange> result = new TreeMap<Double, SegmentWithRange>();
        Map<Long, List<SegmentWithRange>> replacedRanges = replacementRanges.getReplacementRanges();
        List<SegmentWithRange> replacements = replacedRanges.get(segment.getSegmentId());
        Preconditions.checkNotNull(replacements, "Empty set of replacements for: {}", segment.getSegmentId());
        replacements.sort(Comparator.comparingDouble(s2 -> s2.getRange().getHigh()).reversed());
        this.verifyContinuous(replacements);
        for (Map.Entry existingEntry : this.segments.descendingMap().entrySet()) {
            SegmentWithRange existingSegment = (SegmentWithRange)existingEntry.getValue();
            if (existingSegment.equals(replacedSegment)) {
                for (SegmentWithRange segmentWithRange : replacements) {
                    Double lowerBound = (Double)this.segments.lowerKey(existingEntry.getKey());
                    if (lowerBound != null && !(segmentWithRange.getRange().getHigh() >= lowerBound)) continue;
                    result.put(Math.min(segmentWithRange.getRange().getHigh(), (Double)existingEntry.getKey()), segmentWithRange);
                }
                continue;
            }
            result.put((Double)existingEntry.getKey(), (SegmentWithRange)existingEntry.getValue());
        }
        this.removeDuplicates(result);
        return new StreamSegments(result, this.getDelegationToken());
    }

    private void removeDuplicates(NavigableMap<Double, SegmentWithRange> result) {
        Segment last = null;
        Iterator iterator = result.descendingMap().values().iterator();
        while (iterator.hasNext()) {
            SegmentWithRange current = (SegmentWithRange)iterator.next();
            if (current.getSegment().equals(last)) {
                iterator.remove();
            }
            last = current.getSegment();
        }
    }

    private SegmentWithRange findReplacedSegment(Segment segment) {
        return this.segments.values().stream().filter(withRange -> withRange.getSegment().equals(segment)).findFirst().orElseThrow(() -> new IllegalArgumentException("Segment to be replaced should be present in the segment list"));
    }

    private void verifyReplacementRange(SegmentWithRange replacedSegment, StreamSegmentsWithPredecessors replacementSegments) {
        log.debug("Verification of replacement segments {} with the current segments {}", (Object)replacementSegments, (Object)this.segments);
        Map<Long, List<SegmentWithRange>> replacementRanges = replacementSegments.getReplacementRanges();
        List<SegmentWithRange> replacements = replacementRanges.get(replacedSegment.getSegment().getSegmentId());
        Preconditions.checkArgument(replacements != null, "Replacement segments did not contain replacements for segment being replaced");
        if (replacementRanges.size() == 1) {
            Preconditions.checkArgument(replacedSegment.getRange().getHigh() == this.getUpperBound(replacements));
            Preconditions.checkArgument(replacedSegment.getRange().getLow() == this.getLowerBound(replacements));
        } else {
            Preconditions.checkArgument(replacedSegment.getRange().getHigh() <= this.getUpperBound(replacements));
            Preconditions.checkArgument(replacedSegment.getRange().getLow() >= this.getLowerBound(replacements));
        }
        for (Map.Entry<Long, List<SegmentWithRange>> ranges : replacementRanges.entrySet()) {
            Map.Entry upperReplacedSegment = this.segments.floorEntry(this.getUpperBound(ranges.getValue()));
            Map.Entry lowerReplacedSegment = this.segments.higherEntry(this.getLowerBound(ranges.getValue()));
            Preconditions.checkArgument(upperReplacedSegment != null, "Missing replaced replacement segments %s", (Object)replacementSegments);
            Preconditions.checkArgument(lowerReplacedSegment != null, "Missing replaced replacement segments %s", (Object)replacementSegments);
        }
    }

    private void verifyContinuous(List<SegmentWithRange> newSegments) {
        double previous = newSegments.get(0).getRange().getHigh();
        for (SegmentWithRange s2 : newSegments) {
            Preconditions.checkArgument(previous == s2.getRange().getHigh(), "Replacement segments were not continious: {}", newSegments);
            previous = s2.getRange().getLow();
        }
    }

    private double getLowerBound(List<SegmentWithRange> values) {
        double lowerReplacementRange = 1.0;
        for (SegmentWithRange range : values) {
            lowerReplacementRange = Math.min(lowerReplacementRange, range.getRange().getLow());
        }
        return lowerReplacementRange;
    }

    private double getUpperBound(List<SegmentWithRange> value) {
        double upperReplacementRange = 0.0;
        for (SegmentWithRange range : value) {
            upperReplacementRange = Math.max(upperReplacementRange, range.getRange().getHigh());
        }
        return upperReplacementRange;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamSegments)) {
            return false;
        }
        StreamSegments other = (StreamSegments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StreamSegments;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

