/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import lombok.Generated;

@Beta
public class KeyValueTableClientConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int initialBackoffMillis;
    private final int maxBackoffMillis;
    private final int retryAttempts;
    private final int backoffMultiple;

    @ConstructorProperties(value={"initialBackoffMillis", "maxBackoffMillis", "retryAttempts", "backoffMultiple"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    KeyValueTableClientConfiguration(int initialBackoffMillis, int maxBackoffMillis, int retryAttempts, int backoffMultiple) {
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.retryAttempts = retryAttempts;
        this.backoffMultiple = backoffMultiple;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static KeyValueTableClientConfigurationBuilder builder() {
        return new KeyValueTableClientConfigurationBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBackoffMultiple() {
        return this.backoffMultiple;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValueTableClientConfiguration)) {
            return false;
        }
        KeyValueTableClientConfiguration other = (KeyValueTableClientConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialBackoffMillis() != other.getInitialBackoffMillis()) {
            return false;
        }
        if (this.getMaxBackoffMillis() != other.getMaxBackoffMillis()) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        return this.getBackoffMultiple() == other.getBackoffMultiple();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyValueTableClientConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialBackoffMillis();
        result = result * 59 + this.getMaxBackoffMillis();
        result = result * 59 + this.getRetryAttempts();
        result = result * 59 + this.getBackoffMultiple();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "KeyValueTableClientConfiguration(initialBackoffMillis=" + this.getInitialBackoffMillis() + ", maxBackoffMillis=" + this.getMaxBackoffMillis() + ", retryAttempts=" + this.getRetryAttempts() + ", backoffMultiple=" + this.getBackoffMultiple() + ")";
    }

    public static final class KeyValueTableClientConfigurationBuilder {
        private int initialBackoffMillis = 10;
        private int maxBackoffMillis = 30000;
        private int retryAttempts = 10;
        private int backoffMultiple = 4;

        public KeyValueTableClientConfiguration build() {
            Preconditions.checkArgument(this.initialBackoffMillis >= 0, "Initial backoff must be non-negative number.");
            Preconditions.checkArgument(this.backoffMultiple >= 0, "Backoff multiple must be a non-negative number.");
            Preconditions.checkArgument(this.maxBackoffMillis >= 0, "Max backoff time must be non-negative number.");
            Preconditions.checkArgument(this.retryAttempts > 0, "Retry attempts must be a positive number.");
            return new KeyValueTableClientConfiguration(this.initialBackoffMillis, this.maxBackoffMillis, this.retryAttempts, this.backoffMultiple);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        KeyValueTableClientConfigurationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyValueTableClientConfigurationBuilder initialBackoffMillis(int initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyValueTableClientConfigurationBuilder maxBackoffMillis(int maxBackoffMillis) {
            this.maxBackoffMillis = maxBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyValueTableClientConfigurationBuilder retryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyValueTableClientConfigurationBuilder backoffMultiple(int backoffMultiple) {
            this.backoffMultiple = backoffMultiple;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "KeyValueTableClientConfiguration.KeyValueTableClientConfigurationBuilder(initialBackoffMillis=" + this.initialBackoffMillis + ", maxBackoffMillis=" + this.maxBackoffMillis + ", retryAttempts=" + this.retryAttempts + ", backoffMultiple=" + this.backoffMultiple + ")";
        }
    }
}

