/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

public class TableSegmentKey {
    @NonNull
    private final ByteBuf key;
    @NonNull
    private final TableSegmentKeyVersion version;

    public static TableSegmentKey unversioned(ByteBuf key) {
        return new TableSegmentKey(key, TableSegmentKeyVersion.NO_VERSION);
    }

    public static TableSegmentKey unversioned(byte[] key) {
        return TableSegmentKey.unversioned(Unpooled.wrappedBuffer(key));
    }

    public static TableSegmentKey versioned(ByteBuf key, long version) {
        return new TableSegmentKey(key, TableSegmentKeyVersion.from(version));
    }

    public static TableSegmentKey versioned(byte[] key, long version) {
        return TableSegmentKey.versioned(Unpooled.wrappedBuffer(key), version);
    }

    public static TableSegmentKey notExists(ByteBuf key) {
        return new TableSegmentKey(key, TableSegmentKeyVersion.NOT_EXISTS);
    }

    public static TableSegmentKey notExists(byte[] key) {
        return TableSegmentKey.notExists(Unpooled.wrappedBuffer(key));
    }

    boolean exists() {
        return this.getVersion().getSegmentVersion() != TableSegmentKeyVersion.NOT_EXISTS.getSegmentVersion();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuf getKey() {
        return this.key;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableSegmentKeyVersion getVersion() {
        return this.version;
    }

    @ConstructorProperties(value={"key", "version"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    TableSegmentKey(@NonNull ByteBuf key, @NonNull TableSegmentKeyVersion version) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.key = key;
        this.version = version;
    }
}

