/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common;

import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;

public final class LoggerHelpers {
    private static final Supplier<Long> CURRENT_TIME = System::nanoTime;
    private static final Function<Long, Long> ELAPSED_MICRO = startTime -> (CURRENT_TIME.get() - startTime) / 1000L;

    public static long traceEnter(Logger log, String method, Object ... args) {
        if (!log.isTraceEnabled()) {
            return 0L;
        }
        long time = CURRENT_TIME.get();
        log.trace("ENTER {}@{} {}.", method, time, args);
        return time;
    }

    public static long traceEnterWithContext(Logger log, String context, String method, Object ... args) {
        if (!log.isTraceEnabled()) {
            return 0L;
        }
        long time = CURRENT_TIME.get();
        log.trace("ENTER {}::{}@{} {}.", context, method, time, args);
        return time;
    }

    public static void traceLeave(Logger log, String method, long traceEnterId, Object ... args) {
        if (!log.isTraceEnabled()) {
            return;
        }
        if (args.length == 0) {
            log.trace("LEAVE {}@{} (elapsed={}us).", method, traceEnterId, ELAPSED_MICRO.apply(traceEnterId));
        } else {
            log.trace("LEAVE {}@{} {} (elapsed={}us).", method, traceEnterId, args, ELAPSED_MICRO.apply(traceEnterId));
        }
    }

    public static void traceLeave(Logger log, String context, String method, long traceEnterId, Object ... args) {
        if (!log.isTraceEnabled()) {
            return;
        }
        if (args.length == 0) {
            log.trace("LEAVE {}::{}@{} (elapsed={}us).", context, method, traceEnterId, ELAPSED_MICRO.apply(traceEnterId));
        } else {
            log.trace("LEAVE {}::{}@{} {} (elapsed={}us).", context, method, traceEnterId, args, ELAPSED_MICRO.apply(traceEnterId));
        }
    }

    public static Object exceptionSummary(Logger log, Throwable e) {
        if (log.isDebugEnabled()) {
            return e;
        }
        return e.toString();
    }
}

