/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common;

import com.google.common.base.Preconditions;

public class MathHelpers {
    public static int abs(int in) {
        return in & Integer.MAX_VALUE;
    }

    public static long abs(long in) {
        return in & Long.MAX_VALUE;
    }

    public static int minMax(int value, int min2, int max) {
        Preconditions.checkArgument(min2 <= max, "min must be less than or equal to max");
        return Math.max(Math.min(value, max), min2);
    }

    public static long minMax(long value, long min2, long max) {
        Preconditions.checkArgument(min2 <= max, "min must be less than or equal to max");
        return Math.max(Math.min(value, max), min2);
    }

    public static double minMax(double value, double min2, double max) {
        Preconditions.checkArgument(min2 <= max, "min must be less than or equal to max");
        return Math.max(Math.min(value, max), min2);
    }
}

